/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FloatingPointFormula;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.UfDeclaration;
import org.sosy_lab.solver.basicimpl.AbstractFormula;
import org.sosy_lab.solver.basicimpl.FormulaTransformationVisitorImpl;
import org.sosy_lab.solver.basicimpl.RecursiveFormulaVisitor;
import org.sosy_lab.solver.basicimpl.UfDeclarationImpl;
import org.sosy_lab.solver.visitors.DefaultFormulaVisitor;
import org.sosy_lab.solver.visitors.FormulaTransformationVisitor;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

public abstract class FormulaCreator<TFormulaInfo, TType, TEnv> {
    private final TType boolType;
    @Nullable
    private final TType integerType;
    @Nullable
    private final TType rationalType;
    protected final TEnv environment;
    public Function<TFormulaInfo, BooleanFormula> encapsulateBoolean = new Function<TFormulaInfo, BooleanFormula>(){

        public BooleanFormula apply(TFormulaInfo pInput) {
            return FormulaCreator.this.encapsulateBoolean(pInput);
        }
    };

    protected FormulaCreator(TEnv env, TType boolType, @Nullable TType pIntegerType, @Nullable TType pRationalType) {
        this.environment = env;
        this.boolType = boolType;
        this.integerType = pIntegerType;
        this.rationalType = pRationalType;
    }

    public final TEnv getEnv() {
        return this.environment;
    }

    public final TType getBoolType() {
        return this.boolType;
    }

    public final TType getIntegerType() {
        if (this.integerType == null) {
            throw new UnsupportedOperationException("Integer theory is not supported by this solver.");
        }
        return this.integerType;
    }

    public final TType getRationalType() {
        if (this.rationalType == null) {
            throw new UnsupportedOperationException("Rational theory is not supported by this solver.");
        }
        return this.rationalType;
    }

    public abstract TType getBitvectorType(int var1);

    public abstract TType getFloatingPointType(FormulaType.FloatingPointType var1);

    public abstract TType getArrayType(TType var1, TType var2);

    public abstract TFormulaInfo makeVariable(TType var1, String var2);

    public BooleanFormula encapsulateBoolean(TFormulaInfo pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType());
        return new AbstractFormula.BooleanFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected BitvectorFormula encapsulateBitvector(TFormulaInfo pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType());
        return new AbstractFormula.BitvectorFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected FloatingPointFormula encapsulateFloatingPoint(TFormulaInfo pTerm) {
        assert (this.getFormulaType(pTerm).isFloatingPointType());
        return new AbstractFormula.FloatingPointFormulaImpl<TFormulaInfo>(pTerm);
    }

    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(TFormulaInfo pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType))) : "Expected: " + this.getFormulaType(pTerm) + " but found: " + FormulaType.getArrayType(pIndexType, pElementType);
        return new AbstractFormula.ArrayFormulaImpl<TI, TE, TFormulaInfo>(pTerm, pIndexType, pElementType);
    }

    public Formula encapsulateWithTypeOf(TFormulaInfo pTerm) {
        return this.encapsulate(this.getFormulaType(pTerm), pTerm);
    }

    public <T extends Formula> T encapsulate(FormulaType<T> pType, TFormulaInfo pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm))) : String.format("Trying to encapsulate formula %s of type %s as %s", pTerm, this.getFormulaType(pTerm), pType);
        if (pType.isBooleanType()) {
            return (T)new AbstractFormula.BooleanFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new AbstractFormula.IntegerFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new AbstractFormula.RationalFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isBitvectorType()) {
            return (T)new AbstractFormula.BitvectorFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)new AbstractFormula.FloatingPointFormulaImpl<TFormulaInfo>(pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrayType = (FormulaType.ArrayFormulaType)pType;
            return (T)this.encapsulateArray(pTerm, arrayType.getIndexType(), arrayType.getElementType());
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in the Solver!");
    }

    protected TFormulaInfo extractInfo(Formula pT) {
        if (pT instanceof AbstractFormula) {
            return ((AbstractFormula)pT).getFormulaInfo();
        }
        throw new IllegalArgumentException("Cannot get the formula info of type " + pT.getClass().getSimpleName() + " in the Solver!");
    }

    protected <TI extends Formula, TE extends Formula> FormulaType<TE> getArrayFormulaElementType(ArrayFormula<TI, TE> pArray) {
        return ((AbstractFormula.ArrayFormulaImpl)pArray).getElementType();
    }

    protected <TI extends Formula, TE extends Formula> FormulaType<TI> getArrayFormulaIndexType(ArrayFormula<TI, TE> pArray) {
        return ((AbstractFormula.ArrayFormulaImpl)pArray).getIndexType();
    }

    protected <T extends Formula> FormulaType<T> getFormulaType(T formula) {
        FormulaType<Formula> t;
        Preconditions.checkNotNull(formula);
        if (formula instanceof BooleanFormula) {
            t = FormulaType.BooleanType;
        } else if (formula instanceof NumeralFormula.IntegerFormula) {
            t = FormulaType.IntegerType;
        } else if (formula instanceof NumeralFormula.RationalFormula) {
            t = FormulaType.RationalType;
        } else {
            if (formula instanceof ArrayFormula) {
                throw new UnsupportedOperationException("SMT solvers with support for arrays need to overwrite FormulaCreator.getFormulaType()");
            }
            if (formula instanceof BitvectorFormula) {
                throw new UnsupportedOperationException("SMT solvers with support for bitvectors need to overwrite FormulaCreator.getFormulaType()");
            }
            throw new IllegalArgumentException("Formula with unexpected type " + formula.getClass());
        }
        return t;
    }

    public abstract FormulaType<?> getFormulaType(TFormulaInfo var1);

    public <T extends Formula, TF> UfDeclaration<T> createUfDeclaration(FormulaType<T> returnType, TF funcDecl, List<FormulaType<?>> argumentTypes) {
        return new UfDeclarationImpl<T, TF>(returnType, funcDecl, argumentTypes);
    }

    @CanIgnoreReturnValue
    public <R> R visit(FormulaVisitor<R> visitor, Formula input) {
        return this.visit(visitor, input, this.extractInfo(input));
    }

    public abstract <R> R visit(FormulaVisitor<R> var1, Formula var2, TFormulaInfo var3);

    protected List<TFormulaInfo> extractInfo(List<Formula> input) {
        return Lists.transform(input, (Function)new Function<Formula, TFormulaInfo>(){

            public TFormulaInfo apply(Formula formula) {
                return FormulaCreator.this.extractInfo(formula);
            }
        });
    }

    public void visitRecursively(FormulaVisitor<TraversalProcess> pFormulaVisitor, Formula pF) {
        RecursiveFormulaVisitor recVisitor = new RecursiveFormulaVisitor(pFormulaVisitor);
        recVisitor.addToQueue(pF);
        while (!recVisitor.isQueueEmpty()) {
            TraversalProcess process = (TraversalProcess)((Object)Preconditions.checkNotNull((Object)((Object)this.visit(recVisitor, recVisitor.pop()))));
            if (process != TraversalProcess.ABORT) continue;
            return;
        }
    }

    public <T extends Formula> T transformRecursively(FormulaTransformationVisitor pFormulaVisitor, T pF) {
        ArrayDeque<Formula> toProcess = new ArrayDeque<Formula>();
        HashMap<Formula, Formula> pCache = new HashMap<Formula, Formula>();
        FormulaTransformationVisitorImpl recVisitor = new FormulaTransformationVisitorImpl(pFormulaVisitor, toProcess, pCache);
        toProcess.push(pF);
        while (!toProcess.isEmpty()) {
            Formula tt = (Formula)toProcess.peek();
            if (pCache.containsKey(tt)) {
                toProcess.pop();
                continue;
            }
            this.visit(recVisitor, tt);
        }
        Formula out = (Formula)pCache.get(pF);
        return (T)out;
    }

    public Map<String, TFormulaInfo> extractVariablesAndUFs(TFormulaInfo pFormula, boolean extractUFs) {
        return Maps.transformValues(this.extractVariablesAndUFs(this.encapsulateWithTypeOf(pFormula), extractUFs), (Function)new Function<Formula, TFormulaInfo>(){

            public TFormulaInfo apply(Formula input) {
                return FormulaCreator.this.extractInfo(input);
            }
        });
    }

    public Map<String, Formula> extractVariablesAndUFs(Formula pFormula, final boolean extractUF) {
        final HashMap<String, Formula> found = new HashMap<String, Formula>();
        this.visitRecursively((FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration functionDeclaration, Function<List<Formula>, Formula> constructor) {
                if (functionDeclaration.getKind() == FunctionDeclarationKind.UF && extractUF) {
                    found.put(functionDeclaration.getName(), f);
                }
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFreeVariable(Formula f, String name) {
                found.put(name, f);
                return TraversalProcess.CONTINUE;
            }
        }, pFormula);
        return found;
    }
}

