/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.InterpolatingProverEnvironment;
import org.sosy_lab.solver.api.InterpolatingProverEnvironmentWithAssumptions;
import org.sosy_lab.solver.api.ProverEnvironment;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.InterpolatingProverWithAssumptionsWrapper;
import org.sosy_lab.solver.logging.LoggingInterpolatingProverEnvironment;
import org.sosy_lab.solver.logging.LoggingProverEnvironment;

@Options(prefix="solver")
public abstract class AbstractSolverContext
implements SolverContext {
    @Option(secure=true, name="useLogger", description="Log solver actions, this may be slow!")
    private boolean useLogger = false;
    private final LogManager logger;
    private final FormulaManager fmgr;

    protected AbstractSolverContext(Configuration config, LogManager pLogger, FormulaManager fmgr) throws InvalidConfigurationException {
        this.logger = pLogger;
        this.fmgr = fmgr;
        config.inject((Object)this, AbstractSolverContext.class);
    }

    @Override
    public final ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... options) {
        ProverEnvironment pe = this.newProverEnvironment0(options);
        if (this.useLogger) {
            pe = new LoggingProverEnvironment(this.logger, pe);
        }
        return pe;
    }

    public abstract ProverEnvironment newProverEnvironment0(SolverContext.ProverOptions ... var1);

    @Override
    public final InterpolatingProverEnvironmentWithAssumptions<?> newProverEnvironmentWithInterpolation() {
        InterpolatingProverEnvironment<?> ipe = this.newProverEnvironmentWithInterpolation0();
        InterpolatingProverEnvironmentWithAssumptions<?> out = !(ipe instanceof InterpolatingProverEnvironmentWithAssumptions) ? new InterpolatingProverWithAssumptionsWrapper(ipe, this.fmgr) : (InterpolatingProverWithAssumptionsWrapper)ipe;
        if (this.useLogger) {
            out = new LoggingInterpolatingProverEnvironment(this.logger, out);
        }
        return out;
    }

    public abstract InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0();
}

