/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionFormulaManager;
import org.sosy_lab.solver.api.UfDeclaration;
import org.sosy_lab.solver.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.basicimpl.UfDeclarationImpl;

public abstract class AbstractFunctionFormulaManager<TFormulaInfo, TFunctionDecl, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv>
implements FunctionFormulaManager {
    protected AbstractFunctionFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pCreator) {
        super(pCreator);
    }

    protected abstract TFunctionDecl declareUninterpretedFunctionImpl(String var1, TType var2, List<TType> var3);

    @Override
    public final <T extends Formula> UfDeclaration<T> declareUninterpretedFunction(String pName, FormulaType<T> pReturnType, List<FormulaType<?>> pArgTypes) {
        Preconditions.checkArgument((!pArgTypes.contains(FormulaType.BooleanType) ? 1 : 0) != 0, (Object)"Uninterpreted functions with boolean arguments are currently not supported in JavaSMT.");
        ArrayList argTypes = new ArrayList(pArgTypes.size());
        for (FormulaType<?> argtype : pArgTypes) {
            argTypes.add(this.toSolverType(argtype));
        }
        return new UfDeclarationImpl<T, TFunctionDecl>(pReturnType, this.declareUninterpretedFunctionImpl(pName, this.toSolverType(pReturnType), argTypes), pArgTypes);
    }

    @Override
    public <T extends Formula> UfDeclaration<T> declareUninterpretedFunction(String pName, FormulaType<T> pReturnType, FormulaType<?> ... pArgs) {
        return this.declareUninterpretedFunction(pName, pReturnType, Arrays.asList(pArgs));
    }

    protected abstract TFormulaInfo createUninterpretedFunctionCallImpl(TFunctionDecl var1, List<TFormulaInfo> var2);

    @Override
    public <T extends Formula> T callUninterpretedFunction(UfDeclaration<T> funcType, Formula ... args) {
        return this.callUninterpretedFunction(funcType, Arrays.asList(args));
    }

    @Override
    public final <T extends Formula> T callUninterpretedFunction(UfDeclaration<T> pFunc, List<? extends Formula> pArgs) {
        FormulaType<T> retType = pFunc.getReturnType();
        List list = Lists.transform(pArgs, (Function)this.extractor);
        TFormulaInfo formulaInfo = this.createUninterpretedFunctionCallImpl(pFunc, list);
        return this.getFormulaCreator().encapsulate(retType, formulaInfo);
    }

    final <T extends Formula> TFormulaInfo createUninterpretedFunctionCallImpl(UfDeclaration<T> pFunc, List<TFormulaInfo> pArgs) {
        UfDeclarationImpl func = (UfDeclarationImpl)pFunc;
        return this.createUninterpretedFunctionCallImpl(func.getFuncDecl(), pArgs);
    }

    @Override
    public <T extends Formula> T declareAndCallUninterpretedFunction(String name, FormulaType<T> pReturnType, List<Formula> pArgs) {
        ImmutableList argTypes = FluentIterable.from(pArgs).transform(new Function<Formula, FormulaType<?>>(){

            public FormulaType<?> apply(Formula pArg0) {
                return AbstractFunctionFormulaManager.this.getFormulaCreator().getFormulaType(pArg0);
            }
        }).toList();
        UfDeclaration<T> func = this.declareUninterpretedFunction(name, pReturnType, (List<FormulaType<?>>)argTypes);
        return this.callUninterpretedFunction(func, pArgs);
    }
}

