/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.solver.api.ArrayFormula;
import org.sosy_lab.solver.api.ArrayFormulaManager;
import org.sosy_lab.solver.api.BitvectorFormula;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.FloatingPointFormula;
import org.sosy_lab.solver.api.FloatingPointFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaManager;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.IntegerFormulaManager;
import org.sosy_lab.solver.api.NumeralFormula;
import org.sosy_lab.solver.api.RationalFormulaManager;
import org.sosy_lab.solver.api.SolverContext;
import org.sosy_lab.solver.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractFunctionFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.basicimpl.tactics.Tactic;
import org.sosy_lab.solver.visitors.FormulaTransformationVisitor;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

public abstract class AbstractFormulaManager<TFormulaInfo, TType, TEnv>
implements FormulaManager {
    @Nullable
    private final AbstractArrayFormulaManager<TFormulaInfo, TType, TEnv> arrayManager;
    private final AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv> booleanManager;
    @Nullable
    private final IntegerFormulaManager integerManager;
    @Nullable
    private final RationalFormulaManager rationalManager;
    @Nullable
    private final AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv> bitvectorManager;
    @Nullable
    private final AbstractFloatingPointFormulaManager<TFormulaInfo, TType, TEnv> floatingPointManager;
    private final AbstractFunctionFormulaManager<TFormulaInfo, ?, TType, TEnv> functionManager;
    @Nullable
    private final AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv> quantifiedManager;
    private final FormulaCreator<TFormulaInfo, TType, TEnv> formulaCreator;

    protected AbstractFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pFormulaCreator, AbstractFunctionFormulaManager<TFormulaInfo, ?, TType, TEnv> functionManager, AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv> booleanManager, @Nullable IntegerFormulaManager pIntegerManager, @Nullable RationalFormulaManager pRationalManager, @Nullable AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv> bitvectorManager, @Nullable AbstractFloatingPointFormulaManager<TFormulaInfo, TType, TEnv> floatingPointManager, @Nullable AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv> quantifiedManager, @Nullable AbstractArrayFormulaManager<TFormulaInfo, TType, TEnv> arrayManager) {
        this.arrayManager = arrayManager;
        this.quantifiedManager = quantifiedManager;
        this.functionManager = (AbstractFunctionFormulaManager)Preconditions.checkNotNull(functionManager, (Object)"function manager needed");
        this.booleanManager = (AbstractBooleanFormulaManager)Preconditions.checkNotNull(booleanManager, (Object)"boolean manager needed");
        this.integerManager = pIntegerManager;
        this.rationalManager = pRationalManager;
        this.bitvectorManager = bitvectorManager;
        this.floatingPointManager = floatingPointManager;
        this.formulaCreator = pFormulaCreator;
        if (booleanManager.getFormulaCreator() != this.formulaCreator || functionManager.getFormulaCreator() != this.formulaCreator || bitvectorManager != null && bitvectorManager.getFormulaCreator() != this.formulaCreator || floatingPointManager != null && floatingPointManager.getFormulaCreator() != this.formulaCreator) {
            throw new IllegalArgumentException("The creator instances must match across the managers!");
        }
    }

    public final FormulaCreator<TFormulaInfo, TType, TEnv> getFormulaCreator() {
        return this.formulaCreator;
    }

    @Override
    public IntegerFormulaManager getIntegerFormulaManager() {
        if (this.integerManager == null) {
            throw new UnsupportedOperationException("Solver does not support integer theory");
        }
        return this.integerManager;
    }

    @Override
    public RationalFormulaManager getRationalFormulaManager() {
        if (this.rationalManager == null) {
            throw new UnsupportedOperationException("Solver does not support rationals theory");
        }
        return this.rationalManager;
    }

    @Override
    public AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv> getBooleanFormulaManager() {
        return this.booleanManager;
    }

    @Override
    public AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv> getBitvectorFormulaManager() {
        if (this.bitvectorManager == null) {
            throw new UnsupportedOperationException("Solver does not support bitvector theory");
        }
        return this.bitvectorManager;
    }

    @Override
    public FloatingPointFormulaManager getFloatingPointFormulaManager() {
        if (this.floatingPointManager == null) {
            throw new UnsupportedOperationException("Solver does not support floating point theory");
        }
        return this.floatingPointManager;
    }

    @Override
    public AbstractFunctionFormulaManager<TFormulaInfo, ?, TType, TEnv> getFunctionFormulaManager() {
        return this.functionManager;
    }

    @Override
    public AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv> getQuantifiedFormulaManager() {
        if (this.quantifiedManager == null) {
            throw new UnsupportedOperationException("Solver does not support quantification");
        }
        return this.quantifiedManager;
    }

    @Override
    public ArrayFormulaManager getArrayFormulaManager() {
        if (this.arrayManager == null) {
            throw new UnsupportedOperationException("Solver does not support arrays");
        }
        return this.arrayManager;
    }

    public abstract Appender dumpFormula(TFormulaInfo var1);

    @Override
    public Appender dumpFormula(BooleanFormula t) {
        return this.dumpFormula(this.formulaCreator.extractInfo(t));
    }

    @Override
    public final <T extends Formula> FormulaType<T> getFormulaType(T formula) {
        return this.formulaCreator.getFormulaType((Formula)Preconditions.checkNotNull(formula));
    }

    public final TEnv getEnvironment() {
        return this.getFormulaCreator().getEnv();
    }

    public final TFormulaInfo extractInfo(Formula f) {
        return this.formulaCreator.extractInfo(f);
    }

    @Override
    public BooleanFormula applyTactic(BooleanFormula f, Tactic tactic) throws InterruptedException {
        return this.formulaCreator.encapsulateBoolean(this.applyTacticImpl(this.extractInfo(f), tactic));
    }

    protected TFormulaInfo applyTacticImpl(TFormulaInfo f, Tactic tactic) throws InterruptedException {
        return this.extractInfo(tactic.applyDefault(this, this.formulaCreator.encapsulateBoolean(f)));
    }

    @Override
    public <T extends Formula> T simplify(T f) {
        return (T)this.formulaCreator.encapsulate(this.formulaCreator.getFormulaType(f), this.simplify(this.extractInfo(f)));
    }

    protected TFormulaInfo simplify(TFormulaInfo f) {
        return f;
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula input) {
        return this.formulaCreator.visit(visitor, input);
    }

    @Override
    public void visitRecursively(FormulaVisitor<TraversalProcess> pFormulaVisitor, Formula pF) {
        this.formulaCreator.visitRecursively(pFormulaVisitor, pF);
    }

    @Override
    public <T extends Formula> T transformRecursively(FormulaTransformationVisitor pFormulaVisitor, T f) {
        return this.formulaCreator.transformRecursively(pFormulaVisitor, f);
    }

    @Override
    public Map<String, Formula> extractVariables(Formula f) {
        return this.formulaCreator.extractVariablesAndUFs(f, false);
    }

    @Override
    public Map<String, Formula> extractVariablesAndUFs(Formula f) {
        return this.formulaCreator.extractVariablesAndUFs(f, true);
    }

    private <T extends Formula> T encapsulateWithTypeOf(T f, TFormulaInfo e) {
        return (T)this.formulaCreator.encapsulate(this.formulaCreator.getFormulaType(f), e);
    }

    @Override
    public <T extends Formula> List<T> splitNumeralEqualityIfPossible(final T pF) {
        return Lists.transform(this.splitNumeralEqualityIfPossible(this.extractInfo(pF)), (Function)new Function<TFormulaInfo, T>(){

            public T apply(TFormulaInfo input) {
                return AbstractFormulaManager.this.encapsulateWithTypeOf(pF, input);
            }
        });
    }

    protected abstract List<? extends TFormulaInfo> splitNumeralEqualityIfPossible(TFormulaInfo var1);

    protected final <T1 extends Formula, T2 extends Formula> T1 substituteUsingMap(T1 pF, Map<? extends Formula, ? extends Formula> pFromToMapping) {
        HashMap<TFormulaInfo, TFormulaInfo> mapping = new HashMap<TFormulaInfo, TFormulaInfo>(pFromToMapping.size());
        for (Map.Entry<? extends Formula, ? extends Formula> entry : pFromToMapping.entrySet()) {
            mapping.put(this.extractInfo(entry.getKey()), this.extractInfo(entry.getValue()));
        }
        TFormulaInfo result = this.substituteUsingMapImpl(this.extractInfo(pF), mapping, pF, pFromToMapping);
        FormulaType<?> type = this.getFormulaCreator().getFormulaType(pF);
        return (T1)this.getFormulaCreator().encapsulate(type, result);
    }

    protected TFormulaInfo substituteUsingMapImpl(TFormulaInfo expr, Map<TFormulaInfo, TFormulaInfo> memoization, Formula f, final Map<? extends Formula, ? extends Formula> fromToMapping) {
        return this.formulaCreator.extractInfo(this.transformRecursively(new FormulaTransformationVisitor(this){

            @Override
            public Formula visitFreeVariable(Formula f, String name) {
                return this.replace(f);
            }

            @Override
            public Formula visitFunction(Formula f, List<Formula> newArgs, FunctionDeclaration functionDeclaration, Function<List<Formula>, Formula> newApplicationConstructor) {
                Formula out = (Formula)fromToMapping.get(f);
                if (out == null) {
                    return (Formula)newApplicationConstructor.apply(newArgs);
                }
                return out;
            }

            private Formula replace(Formula f) {
                Formula out = (Formula)fromToMapping.get(f);
                if (out == null) {
                    return f;
                }
                return out;
            }
        }, f));
    }

    protected final <T1 extends Formula> T1 substituteUsingLists(T1 pF, Map<? extends Formula, ? extends Formula> pFromToMapping) {
        ArrayList<TFormulaInfo> substituteFrom = new ArrayList<TFormulaInfo>(pFromToMapping.size());
        ArrayList<TFormulaInfo> substituteTo = new ArrayList<TFormulaInfo>(pFromToMapping.size());
        for (Map.Entry<? extends Formula, ? extends Formula> entry : pFromToMapping.entrySet()) {
            substituteFrom.add(this.extractInfo(entry.getKey()));
            substituteTo.add(this.extractInfo(entry.getValue()));
        }
        TFormulaInfo result = this.substituteUsingListsImpl(this.extractInfo(pF), substituteFrom, substituteTo);
        FormulaType<?> type = this.getFormulaCreator().getFormulaType(pF);
        return (T1)this.getFormulaCreator().encapsulate(type, result);
    }

    protected TFormulaInfo substituteUsingListsImpl(TFormulaInfo pF, List<TFormulaInfo> substituteFrom, List<TFormulaInfo> substituteTo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BooleanFormula translate(BooleanFormula other, SolverContext otherContext) {
        return this.parse(otherContext.getFormulaManager().dumpFormula(other).toString());
    }

    @Override
    public <T extends Formula> BooleanFormula makeEqual(T pLhs, T pRhs) {
        Formula t;
        if (pLhs instanceof BooleanFormula && pRhs instanceof BooleanFormula) {
            t = this.booleanManager.equivalence((BooleanFormula)pLhs, (BooleanFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula.IntegerFormula && pRhs instanceof NumeralFormula.IntegerFormula) {
            assert (this.integerManager != null);
            t = this.integerManager.equal((NumeralFormula.IntegerFormula)pLhs, (NumeralFormula.IntegerFormula)pRhs);
        } else if (pLhs instanceof NumeralFormula && pRhs instanceof NumeralFormula) {
            assert (this.rationalManager != null);
            t = this.rationalManager.equal((NumeralFormula)pLhs, (NumeralFormula)pRhs);
        } else if (pLhs instanceof BitvectorFormula) {
            assert (this.bitvectorManager != null);
            t = this.bitvectorManager.equal((BitvectorFormula)pLhs, (BitvectorFormula)pRhs);
        } else if (pLhs instanceof FloatingPointFormula && pRhs instanceof FloatingPointFormula) {
            assert (this.floatingPointManager != null);
            t = this.floatingPointManager.equalWithFPSemantics((FloatingPointFormula)pLhs, (FloatingPointFormula)pRhs);
        } else if (pLhs instanceof ArrayFormula && pRhs instanceof ArrayFormula) {
            assert (this.arrayManager != null);
            ArrayFormula rhs = (ArrayFormula)pRhs;
            ArrayFormula t2 = this.arrayManager.equivalence((ArrayFormula)pLhs, rhs);
            t = t2;
        } else {
            throw new IllegalArgumentException("No supported interface found for formulas: " + pLhs + " and " + pRhs);
        }
        return t;
    }

    @Override
    public <T extends Formula> T makeVariable(FormulaType<T> formulaType, String name) {
        Formula t;
        if (formulaType.isBooleanType()) {
            t = this.booleanManager.makeVariable(name);
        } else if (formulaType.isIntegerType()) {
            assert (this.integerManager != null);
            t = this.integerManager.makeVariable(name);
        } else if (formulaType.isRationalType()) {
            assert (this.rationalManager != null);
            t = this.rationalManager.makeVariable(name);
        } else if (formulaType.isBitvectorType()) {
            assert (this.bitvectorManager != null);
            FormulaType.BitvectorType impl = (FormulaType.BitvectorType)formulaType;
            t = this.bitvectorManager.makeVariable((FormulaType.BitvectorType)formulaType, name);
        } else if (formulaType.isFloatingPointType()) {
            assert (this.floatingPointManager != null);
            t = this.floatingPointManager.makeVariable(name, (FormulaType.FloatingPointType)formulaType);
        } else if (formulaType.isArrayType()) {
            assert (this.arrayManager != null);
            t = this.arrayManager.makeArray(name, (FormulaType.ArrayFormulaType)formulaType);
        } else {
            throw new IllegalArgumentException("Unknown formula type");
        }
        BooleanFormula out = t;
        return (T)out;
    }

    @Override
    public <T extends Formula> T substitute(T pF, Map<? extends Formula, ? extends Formula> pFromToMapping) {
        return this.substituteUsingMap(pF, pFromToMapping);
    }
}

