/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.basicimpl;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.solver.api.BooleanFormula;
import org.sosy_lab.solver.api.BooleanFormulaManager;
import org.sosy_lab.solver.api.Formula;
import org.sosy_lab.solver.api.FormulaType;
import org.sosy_lab.solver.api.FunctionDeclaration;
import org.sosy_lab.solver.api.FunctionDeclarationKind;
import org.sosy_lab.solver.api.QuantifiedFormulaManager;
import org.sosy_lab.solver.basicimpl.AbstractBaseFormulaManager;
import org.sosy_lab.solver.basicimpl.FormulaCreator;
import org.sosy_lab.solver.basicimpl.RecursiveBooleanFormulaVisitor;
import org.sosy_lab.solver.visitors.BooleanFormulaVisitor;
import org.sosy_lab.solver.visitors.FormulaVisitor;
import org.sosy_lab.solver.visitors.TraversalProcess;

public abstract class AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv>
extends AbstractBaseFormulaManager<TFormulaInfo, TType, TEnv>
implements BooleanFormulaManager {
    protected AbstractBooleanFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv> pCreator) {
        super(pCreator);
    }

    private BooleanFormula wrap(TFormulaInfo formulaInfo) {
        return this.getFormulaCreator().encapsulateBoolean(formulaInfo);
    }

    @Override
    public BooleanFormula makeVariable(String pVar) {
        return this.wrap(this.makeVariableImpl(pVar));
    }

    protected abstract TFormulaInfo makeVariableImpl(String var1);

    @Override
    public BooleanFormula makeBoolean(boolean value) {
        return this.wrap(this.makeBooleanImpl(value));
    }

    protected abstract TFormulaInfo makeBooleanImpl(boolean var1);

    @Override
    public BooleanFormula not(BooleanFormula pBits) {
        Object param1 = this.extractInfo(pBits);
        return this.wrap(this.not(param1));
    }

    protected abstract TFormulaInfo not(TFormulaInfo var1);

    @Override
    public BooleanFormula and(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.and(param1, param2));
    }

    protected abstract TFormulaInfo and(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula and(Collection<BooleanFormula> pBits) {
        if (pBits.isEmpty()) {
            return this.makeBoolean(true);
        }
        if (pBits.size() == 1) {
            return (BooleanFormula)Iterables.getOnlyElement(pBits);
        }
        TFormulaInfo result = this.andImpl(Collections2.transform(pBits, (Function)this.extractor));
        return this.wrap(result);
    }

    protected TFormulaInfo andImpl(Collection<TFormulaInfo> pParams) {
        TFormulaInfo result = this.makeBooleanImpl(true);
        for (TFormulaInfo formula : pParams) {
            result = this.and(result, formula);
        }
        return result;
    }

    @Override
    public BooleanFormula or(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.or(param1, param2));
    }

    protected abstract TFormulaInfo or(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public BooleanFormula xor(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.xor(param1, param2));
    }

    @Override
    public BooleanFormula or(Collection<BooleanFormula> pBits) {
        if (pBits.isEmpty()) {
            return this.makeBoolean(false);
        }
        if (pBits.size() == 1) {
            return (BooleanFormula)Iterables.getOnlyElement(pBits);
        }
        TFormulaInfo result = this.orImpl(Collections2.transform(pBits, (Function)this.extractor));
        return this.wrap(result);
    }

    protected TFormulaInfo orImpl(Collection<TFormulaInfo> pParams) {
        TFormulaInfo result = this.makeBooleanImpl(false);
        for (TFormulaInfo formula : pParams) {
            result = this.or(result, formula);
        }
        return result;
    }

    protected abstract TFormulaInfo xor(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public final BooleanFormula equivalence(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.equivalence(param1, param2));
    }

    protected abstract TFormulaInfo equivalence(TFormulaInfo var1, TFormulaInfo var2);

    @Override
    public final BooleanFormula implication(BooleanFormula pBits1, BooleanFormula pBits2) {
        Object param1 = this.extractInfo(pBits1);
        Object param2 = this.extractInfo(pBits2);
        return this.wrap(this.implication(param1, param2));
    }

    protected TFormulaInfo implication(TFormulaInfo bits1, TFormulaInfo bits2) {
        return this.or(this.not(bits1), bits2);
    }

    @Override
    public final boolean isTrue(BooleanFormula pBits) {
        return this.isTrue(this.extractInfo(pBits));
    }

    protected abstract boolean isTrue(TFormulaInfo var1);

    @Override
    public final boolean isFalse(BooleanFormula pBits) {
        return this.isFalse(this.extractInfo(pBits));
    }

    protected abstract boolean isFalse(TFormulaInfo var1);

    @Override
    public final <T extends Formula> T ifThenElse(BooleanFormula pBits, T f1, T f2) {
        FormulaType<?> t1 = this.getFormulaCreator().getFormulaType(f1);
        FormulaType<?> t2 = this.getFormulaCreator().getFormulaType(f2);
        Preconditions.checkArgument((boolean)t1.equals(t2), (String)"Cannot create if-then-else formula with branches of different types: %s is of type %s; %s is of type %s", (Object[])new Object[]{f1, t1, f2, t2});
        Object result = this.ifThenElse(this.extractInfo(pBits), this.extractInfo(f1), this.extractInfo(f2));
        return (T)this.getFormulaCreator().encapsulate(t1, result);
    }

    protected abstract TFormulaInfo ifThenElse(TFormulaInfo var1, TFormulaInfo var2, TFormulaInfo var3);

    @Override
    public <R> R visit(BooleanFormulaVisitor<R> visitor, BooleanFormula pFormula) {
        return this.formulaCreator.visit(new DelegatingFormulaVisitor<R>(visitor), pFormula);
    }

    @Override
    public void visitRecursively(BooleanFormulaVisitor<TraversalProcess> pFormulaVisitor, BooleanFormula pF) {
        RecursiveBooleanFormulaVisitor recVisitor = new RecursiveBooleanFormulaVisitor(pFormulaVisitor);
        recVisitor.addToQueue(pF);
        while (!recVisitor.isQueueEmpty()) {
            TraversalProcess process = (TraversalProcess)((Object)Preconditions.checkNotNull((Object)((Object)this.visit(recVisitor, recVisitor.pop()))));
            if (process != TraversalProcess.ABORT) continue;
            return;
        }
    }

    private class DelegatingFormulaVisitor<R>
    implements FormulaVisitor<R> {
        private final BooleanFormulaVisitor<R> delegate;

        DelegatingFormulaVisitor(BooleanFormulaVisitor<R> pDelegate) {
            this.delegate = pDelegate;
        }

        @Override
        public R visitFreeVariable(Formula f, String name) {
            assert (f instanceof BooleanFormula);
            return this.delegate.visitAtom((BooleanFormula)f, FunctionDeclaration.of(name, FunctionDeclarationKind.VAR));
        }

        @Override
        public R visitBoundVariable(Formula f, int deBruijnIdx) {
            assert (f instanceof BooleanFormula);
            return this.delegate.visitBoundVar((BooleanFormula)f, deBruijnIdx);
        }

        @Override
        public R visitConstant(Formula f, Object value) {
            Preconditions.checkState((boolean)(value instanceof Boolean));
            boolean v = (Boolean)value;
            if (v) {
                return this.delegate.visitTrue();
            }
            return this.delegate.visitFalse();
        }

        private List<BooleanFormula> getBoolArgs(List<Formula> args) {
            List<Formula> out = args;
            return out;
        }

        @Override
        public R visitFunction(Formula f, List<Formula> args, FunctionDeclaration functionDeclaration, Function<List<Formula>, Formula> newApplicationConstructor) {
            switch (functionDeclaration.getKind()) {
                case AND: {
                    Preconditions.checkState((boolean)(args.iterator().next() instanceof BooleanFormula));
                    R out = this.delegate.visitAnd(this.getBoolArgs(args));
                    return out;
                }
                case NOT: {
                    Preconditions.checkState((args.size() == 1 ? 1 : 0) != 0);
                    Formula arg = args.get(0);
                    Preconditions.checkArgument((boolean)(arg instanceof BooleanFormula));
                    return this.delegate.visitNot((BooleanFormula)arg);
                }
                case OR: {
                    Preconditions.checkState((boolean)(args.iterator().next() instanceof BooleanFormula));
                    R out2 = this.delegate.visitOr(this.getBoolArgs(args));
                    return out2;
                }
                case IFF: {
                    Preconditions.checkState((args.size() == 2 ? 1 : 0) != 0);
                    Formula a = args.get(0);
                    Formula b = args.get(1);
                    Preconditions.checkState((a instanceof BooleanFormula && b instanceof BooleanFormula ? 1 : 0) != 0);
                    R out3 = this.delegate.visitEquivalence((BooleanFormula)a, (BooleanFormula)b);
                    return out3;
                }
                case EQ: {
                    if (args.size() == 2 && args.get(0) instanceof BooleanFormula && args.get(1) instanceof BooleanFormula) {
                        return this.delegate.visitEquivalence((BooleanFormula)args.get(0), (BooleanFormula)args.get(1));
                    }
                    return this.delegate.visitAtom((BooleanFormula)f, functionDeclaration);
                }
                case ITE: {
                    Preconditions.checkArgument((args.size() == 3 ? 1 : 0) != 0);
                    Formula ifC = args.get(0);
                    Formula then = args.get(1);
                    Formula elseC = args.get(2);
                    Preconditions.checkState((ifC instanceof BooleanFormula && then instanceof BooleanFormula && elseC instanceof BooleanFormula ? 1 : 0) != 0);
                    return this.delegate.visitIfThenElse((BooleanFormula)ifC, (BooleanFormula)then, (BooleanFormula)elseC);
                }
                case XOR: {
                    Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
                    Formula a1 = args.get(0);
                    Formula a2 = args.get(1);
                    Preconditions.checkState((a1 instanceof BooleanFormula && a2 instanceof BooleanFormula ? 1 : 0) != 0);
                    return this.delegate.visitXor((BooleanFormula)a1, (BooleanFormula)a2);
                }
                case IMPLIES: {
                    Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0);
                    Formula b1 = args.get(0);
                    Formula b2 = args.get(1);
                    Preconditions.checkArgument((b1 instanceof BooleanFormula && b2 instanceof BooleanFormula ? 1 : 0) != 0);
                    return this.delegate.visitImplication((BooleanFormula)b1, (BooleanFormula)b2);
                }
            }
            return this.delegate.visitAtom((BooleanFormula)f, functionDeclaration);
        }

        @Override
        public R visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVariables, BooleanFormula body) {
            return this.delegate.visitQuantifier(quantifier, boundVariables, body);
        }
    }
}

