/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.solver.api;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sosy_lab.solver.api.FunctionDeclarationKind;

public class FunctionDeclaration {
    private final String name;
    private final FunctionDeclarationKind kind;

    private FunctionDeclaration(String name, FunctionDeclarationKind kind) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)kind));
        this.name = name;
        this.kind = kind;
    }

    public static FunctionDeclaration of(String name, FunctionDeclarationKind kind) {
        return new FunctionDeclaration(name, kind);
    }

    public FunctionDeclarationKind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s (%s)", new Object[]{this.kind, this.name});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.name});
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionDeclaration)) {
            return false;
        }
        FunctionDeclaration other = (FunctionDeclaration)o;
        return this.name.equals(other.name) && this.kind.equals((Object)other.kind);
    }
}

