/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.WrapperConfiguration;

public class WrapperExecutor {
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String DISTRIBUTION_BASE_PROPERTY = "distributionBase";
    public static final String DISTRIBUTION_PATH_PROPERTY = "distributionPath";
    public static final String DISTRIBUTION_SHA_256_SUM = "distributionSha256Sum";
    public static final String ZIP_STORE_BASE_PROPERTY = "zipStoreBase";
    public static final String ZIP_STORE_PATH_PROPERTY = "zipStorePath";
    private final Properties properties;
    private final File propertiesFile;
    private final WrapperConfiguration config = new WrapperConfiguration();

    public static WrapperExecutor forProjectDirectory(File projectDir) {
        return new WrapperExecutor(new File(projectDir, "gradle/wrapper/gradle-wrapper.properties"), new Properties());
    }

    public static WrapperExecutor forWrapperPropertiesFile(File propertiesFile) {
        if (!propertiesFile.exists()) {
            throw new RuntimeException(String.format("Wrapper properties file '%s' does not exist.", propertiesFile));
        }
        return new WrapperExecutor(propertiesFile, new Properties());
    }

    WrapperExecutor(File propertiesFile, Properties properties2) {
        this.properties = properties2;
        this.propertiesFile = propertiesFile;
        if (propertiesFile.exists()) {
            try {
                WrapperExecutor.loadProperties(propertiesFile, properties2);
                this.config.setDistribution(this.prepareDistributionUri());
                this.config.setDistributionBase(this.getProperty(DISTRIBUTION_BASE_PROPERTY, this.config.getDistributionBase()));
                this.config.setDistributionPath(this.getProperty(DISTRIBUTION_PATH_PROPERTY, this.config.getDistributionPath()));
                this.config.setDistributionSha256Sum(this.getProperty(DISTRIBUTION_SHA_256_SUM, this.config.getDistributionSha256Sum(), false));
                this.config.setZipBase(this.getProperty(ZIP_STORE_BASE_PROPERTY, this.config.getZipBase()));
                this.config.setZipPath(this.getProperty(ZIP_STORE_PATH_PROPERTY, this.config.getZipPath()));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not load wrapper properties from '%s'.", propertiesFile), e);
            }
        }
    }

    private URI prepareDistributionUri() throws URISyntaxException {
        URI source = this.readDistroUrl();
        if (source.getScheme() == null) {
            return new File(this.propertiesFile.getParentFile(), source.getSchemeSpecificPart()).toURI();
        }
        return source;
    }

    private URI readDistroUrl() throws URISyntaxException {
        if (this.properties.getProperty(DISTRIBUTION_URL_PROPERTY) == null) {
            this.reportMissingProperty(DISTRIBUTION_URL_PROPERTY);
        }
        return new URI(this.getProperty(DISTRIBUTION_URL_PROPERTY));
    }

    private static void loadProperties(File propertiesFile, Properties properties2) throws IOException {
        FileInputStream inStream = new FileInputStream(propertiesFile);
        try {
            properties2.load(inStream);
        }
        finally {
            ((InputStream)inStream).close();
        }
    }

    public URI getDistribution() {
        return this.config.getDistribution();
    }

    public WrapperConfiguration getConfiguration() {
        return this.config;
    }

    public void execute(String[] args2, Install install, BootstrapMainStarter bootstrapMainStarter) throws Exception {
        File gradleHome = install.createDist(this.config);
        bootstrapMainStarter.start(args2, gradleHome);
    }

    private String getProperty(String propertyName) {
        return this.getProperty(propertyName, null, true);
    }

    private String getProperty(String propertyName, String defaultValue) {
        return this.getProperty(propertyName, defaultValue, true);
    }

    private String getProperty(String propertyName, String defaultValue, boolean required) {
        String value2 = this.properties.getProperty(propertyName);
        if (value2 != null) {
            return value2;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        if (required) {
            return this.reportMissingProperty(propertyName);
        }
        return null;
    }

    private String reportMissingProperty(String propertyName) {
        throw new RuntimeException(String.format("No value with key '%s' specified in wrapper properties file '%s'.", propertyName, this.propertiesFile));
    }
}

