/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.common.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.gradle.internal.impldep.com.google.common.annotations.GwtCompatible;
import org.gradle.internal.impldep.com.google.j2objc.annotations.ReflectionSupport;
import org.gradle.internal.impldep.org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
@ReflectionSupport(value=ReflectionSupport.Level.FULL)
abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE;
    private static final Runnable INTERRUPTING;
    private static final Runnable PARKED;
    private static final int MAX_BUSY_WAIT_SPINS = 1000;

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Throwable error;
        T result2;
        boolean run2;
        Thread currentThread;
        block26: {
            currentThread = Thread.currentThread();
            if (!this.compareAndSet(null, currentThread)) {
                return;
            }
            run2 = !this.isDone();
            result2 = null;
            error = null;
            try {
                if (!run2) break block26;
                result2 = this.runInterruptibly();
            }
            catch (Throwable t) {
                try {
                    error = t;
                }
                catch (Throwable throwable) {
                    if (!this.compareAndSet(currentThread, DONE)) {
                        boolean restoreInterruptedBit = false;
                        int spinCount = 0;
                        Runnable state = (Runnable)this.get();
                        while (state == INTERRUPTING || state == PARKED) {
                            if (++spinCount > 1000) {
                                if (state == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                                    restoreInterruptedBit = Thread.interrupted() || restoreInterruptedBit;
                                    LockSupport.park(this);
                                }
                            } else {
                                Thread.yield();
                            }
                            state = (Runnable)this.get();
                        }
                        if (restoreInterruptedBit) {
                            currentThread.interrupt();
                        }
                    }
                    if (run2) {
                        this.afterRanInterruptibly(result2, error);
                    }
                    throw throwable;
                }
                if (!this.compareAndSet(currentThread, DONE)) {
                    boolean restoreInterruptedBit = false;
                    int spinCount = 0;
                    Runnable state = (Runnable)this.get();
                    while (state == INTERRUPTING || state == PARKED) {
                        if (++spinCount > 1000) {
                            if (state == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                                restoreInterruptedBit = Thread.interrupted() || restoreInterruptedBit;
                                LockSupport.park(this);
                            }
                        } else {
                            Thread.yield();
                        }
                        state = (Runnable)this.get();
                    }
                    if (restoreInterruptedBit) {
                        currentThread.interrupt();
                    }
                }
                if (run2) {
                    this.afterRanInterruptibly(result2, error);
                }
            }
        }
        if (!this.compareAndSet(currentThread, DONE)) {
            boolean restoreInterruptedBit = false;
            int spinCount = 0;
            Runnable state = (Runnable)this.get();
            while (state == INTERRUPTING || state == PARKED) {
                if (++spinCount > 1000) {
                    if (state == PARKED || this.compareAndSet(INTERRUPTING, PARKED)) {
                        restoreInterruptedBit = Thread.interrupted() || restoreInterruptedBit;
                        LockSupport.park(this);
                    }
                } else {
                    Thread.yield();
                }
                state = (Runnable)this.get();
            }
            if (restoreInterruptedBit) {
                currentThread.interrupt();
            }
        }
        if (run2) {
            this.afterRanInterruptibly(result2, error);
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptibly(@Nullable T var1, @Nullable Throwable var2);

    final void interruptTask() {
        Runnable currentRunner = (Runnable)this.get();
        if (currentRunner instanceof Thread && this.compareAndSet(currentRunner, INTERRUPTING)) {
            try {
                ((Thread)currentRunner).interrupt();
            }
            finally {
                Runnable prev = this.getAndSet(DONE);
                if (prev == PARKED) {
                    LockSupport.unpark((Thread)currentRunner);
                }
            }
        }
    }

    @Override
    public final String toString() {
        String string2;
        String result2;
        Runnable state = (Runnable)this.get();
        if (state == DONE) {
            result2 = "running=[DONE]";
        } else if (state == INTERRUPTING) {
            result2 = "running=[INTERRUPTED]";
        } else if (state instanceof Thread) {
            string2 = ((Thread)state).getName();
            result2 = new StringBuilder(21 + String.valueOf(string2).length()).append("running=[RUNNING ON ").append(string2).append("]").toString();
        } else {
            result2 = "running=[NOT STARTED YET]";
        }
        string2 = this.toPendingString();
        return new StringBuilder(2 + String.valueOf(result2).length() + String.valueOf(string2).length()).append(result2).append(", ").append(string2).toString();
    }

    abstract String toPendingString();

    static {
        Class<LockSupport> clazz = LockSupport.class;
        DONE = new DoNothingRunnable();
        INTERRUPTING = new DoNothingRunnable();
        PARKED = new DoNothingRunnable();
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

