/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildoption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.internal.buildoption.AbstractBuildOption;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.Origin;

public abstract class EnumBuildOption<E extends Enum<E>, T>
extends AbstractBuildOption<T, CommandLineOptionConfiguration> {
    private final String displayName;
    private final Class<E> enumClass;
    private final List<E> possibleValues;

    public EnumBuildOption(String displayName, Class<E> enumClass2, E[] possibleValues, String gradleProperty, CommandLineOptionConfiguration ... commandLineOptionConfigurations) {
        super(gradleProperty, commandLineOptionConfigurations);
        this.displayName = displayName;
        this.enumClass = enumClass2;
        this.possibleValues = Collections.unmodifiableList(Arrays.asList(possibleValues));
    }

    @Override
    public void applyFromProperty(Map<String, String> properties2, T settings) {
        String value2 = properties2.get(this.gradleProperty);
        if (value2 != null) {
            this.applyTo((E)value2, settings, Origin.forGradleProperty(this.gradleProperty));
        }
    }

    @Override
    public void configure(CommandLineParser parser) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            this.configureCommandLineOption(parser, config.getAllOptions(), config.getDescription(), config.isDeprecated(), config.isIncubating()).hasArgument();
        }
    }

    @Override
    public void applyFromCommandLine(ParsedCommandLine options, T settings) {
        for (CommandLineOptionConfiguration config : this.commandLineOptionConfigurations) {
            if (!options.hasOption(config.getLongOption())) continue;
            String value2 = options.option(config.getLongOption()).getValue();
            this.applyTo((E)value2, settings, Origin.forCommandLine(config.getLongOption()));
        }
    }

    private void applyTo(String value2, T settings, Origin origin) {
        this.applyTo(this.getValue(value2), settings, origin);
    }

    private E getValue(String value2) {
        E enumValue = null;
        if (value2 != null) {
            enumValue = this.tryGetValue(value2);
            if (enumValue == null) {
                enumValue = this.tryGetValue(value2.toLowerCase());
            }
            if (enumValue == null) {
                enumValue = this.tryGetValue(value2.toUpperCase());
            }
        }
        if (enumValue == null) {
            throw new RuntimeException("Option " + this.displayName + " doesn't accept value '" + value2 + "'. Possible values are " + this.possibleValues);
        }
        return enumValue;
    }

    private E tryGetValue(String value2) {
        try {
            return Enum.valueOf(this.enumClass, value2);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public abstract void applyTo(E var1, T var2, Origin var3);
}

