/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cli;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.cli.CommandLineOption;
import org.gradle.cli.ParsedCommandLineOption;

public class ParsedCommandLine {
    private final Map<String, ParsedCommandLineOption> optionsByString = new HashMap<String, ParsedCommandLineOption>();
    private final Set<String> presentOptions = new HashSet<String>();
    private final Set<String> removedOptions = new HashSet<String>();
    private final List<String> extraArguments = new ArrayList<String>();

    ParsedCommandLine(Iterable<CommandLineOption> options) {
        for (CommandLineOption option : options) {
            ParsedCommandLineOption parsedOption = new ParsedCommandLineOption();
            for (String optionStr : option.getOptions()) {
                this.optionsByString.put(optionStr, parsedOption);
            }
        }
    }

    public String toString() {
        return String.format("options: %s, extraArguments: %s, removedOptions: %s", this.quoteAndJoin(this.presentOptions), this.quoteAndJoin(this.extraArguments), this.quoteAndJoin(this.removedOptions));
    }

    private String quoteAndJoin(Iterable<String> strings2) {
        StringBuilder output = new StringBuilder();
        boolean isFirst = true;
        for (String string2 : strings2) {
            if (!isFirst) {
                output.append(", ");
            }
            output.append("'");
            output.append(string2);
            output.append("'");
            isFirst = false;
        }
        return output.toString();
    }

    public boolean hasOption(String option) {
        this.option(option);
        return this.presentOptions.contains(option);
    }

    public boolean hadOptionRemoved(String option) {
        this.option(option);
        return this.removedOptions.contains(option);
    }

    public boolean hasAnyOption(Collection<String> logLevelOptions) {
        for (String option : logLevelOptions) {
            if (!this.hasOption(option)) continue;
            return true;
        }
        return false;
    }

    public ParsedCommandLineOption option(String option) {
        ParsedCommandLineOption parsedOption = this.optionsByString.get(option);
        if (parsedOption == null) {
            throw new IllegalArgumentException(String.format("Option '%s' not defined.", option));
        }
        return parsedOption;
    }

    public List<String> getExtraArguments() {
        return this.extraArguments;
    }

    void addExtraValue(String value2) {
        this.extraArguments.add(value2);
    }

    ParsedCommandLineOption addOption(String optionStr, CommandLineOption option) {
        ParsedCommandLineOption parsedOption = this.optionsByString.get(optionStr);
        this.presentOptions.addAll(option.getOptions());
        return parsedOption;
    }

    void removeOption(CommandLineOption option) {
        for (String optionStr : option.getOptions()) {
            if (!this.presentOptions.remove(optionStr)) continue;
            this.removedOptions.add(optionStr);
        }
    }
}

