/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.ApiExtensionsKt;
import org.sonarsource.kotlin.api.InputFileContext;
import org.sonarsource.kotlin.api.ParseException;
import org.sonarsource.kotlin.api.regex.RegexCache;
import org.sonarsource.kotlin.converter.Environment;
import org.sonarsource.kotlin.converter.KotlinCoreEnvironmentToolsKt;
import org.sonarsource.kotlin.converter.KotlinSyntaxStructure;
import org.sonarsource.kotlin.converter.KotlinTree;
import org.sonarsource.kotlin.plugin.InputFileContextImpl;
import org.sonarsource.kotlin.plugin.IssueSuppressionVisitor;
import org.sonarsource.kotlin.plugin.KotlinCheckListKt;
import org.sonarsource.kotlin.plugin.KotlinLanguage;
import org.sonarsource.kotlin.plugin.KotlinPluginKt;
import org.sonarsource.kotlin.plugin.KotlinSensorKt;
import org.sonarsource.kotlin.plugin.MetricVisitor;
import org.sonarsource.kotlin.plugin.MetricsUtilsKt;
import org.sonarsource.kotlin.plugin.SyntaxHighlighter;
import org.sonarsource.kotlin.plugin.caching.ContentHashCache;
import org.sonarsource.kotlin.plugin.cpd.CPDToken;
import org.sonarsource.kotlin.plugin.cpd.CachingKt;
import org.sonarsource.kotlin.plugin.cpd.CopyPasteDetector;
import org.sonarsource.kotlin.visiting.KotlinFileVisitor;
import org.sonarsource.kotlin.visiting.KtChecksVisitor;
import org.sonarsource.performance.measure.PerformanceMeasure;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JB\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0019H\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020!2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0018\u0010/\u001a\u00020\u00132\u0006\u0010,\u001a\u00020!2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J.\u00103\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/sonarsource/kotlin/plugin/KotlinSensor;", "Lorg/sonar/api/batch/sensor/Sensor;", "checkFactory", "Lorg/sonar/api/batch/rule/CheckFactory;", "fileLinesContextFactory", "Lorg/sonar/api/measures/FileLinesContextFactory;", "noSonarFilter", "Lorg/sonar/api/issue/NoSonarFilter;", "language", "Lorg/sonarsource/kotlin/plugin/KotlinLanguage;", "(Lorg/sonar/api/batch/rule/CheckFactory;Lorg/sonar/api/measures/FileLinesContextFactory;Lorg/sonar/api/issue/NoSonarFilter;Lorg/sonarsource/kotlin/plugin/KotlinLanguage;)V", "checks", "Lorg/sonar/api/batch/rule/Checks;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "getChecks", "()Lorg/sonar/api/batch/rule/Checks;", "getLanguage", "()Lorg/sonarsource/kotlin/plugin/KotlinLanguage;", "analyseFile", "", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "inputFileContext", "Lorg/sonarsource/kotlin/api/InputFileContext;", "visitors", "", "Lorg/sonarsource/kotlin/visiting/KotlinFileVisitor;", "tree", "Lorg/sonarsource/kotlin/converter/KotlinTree;", "analyseFiles", "", "inputFiles", "", "Lorg/sonar/api/batch/fs/InputFile;", "progressReport", "Lorg/sonarsource/analyzer/commons/ProgressReport;", "filenames", "", "canSkipUnchangedFiles", "describe", "descriptor", "Lorg/sonar/api/batch/sensor/SensorDescriptor;", "execute", "fileHasChanged", "inputFile", "contentHashCache", "Lorg/sonarsource/kotlin/plugin/caching/ContentHashCache;", "logParsingError", "e", "Lorg/sonarsource/kotlin/api/ParseException;", "reuseCPDTokens", "visitFile", "sonar-kotlin-plugin"})
public final class KotlinSensor
implements Sensor {
    @NotNull
    private final FileLinesContextFactory fileLinesContextFactory;
    @NotNull
    private final NoSonarFilter noSonarFilter;
    @NotNull
    private final KotlinLanguage language;
    @NotNull
    private final Checks<AbstractCheck> checks;

    /*
     * WARNING - void declaration
     */
    public KotlinSensor(@NotNull CheckFactory checkFactory, @NotNull FileLinesContextFactory fileLinesContextFactory, @NotNull NoSonarFilter noSonarFilter, @NotNull KotlinLanguage language) {
        void $this$checks_u24lambda_u2d1;
        Checks checks2;
        Intrinsics.checkNotNullParameter(checkFactory, "checkFactory");
        Intrinsics.checkNotNullParameter(fileLinesContextFactory, "fileLinesContextFactory");
        Intrinsics.checkNotNullParameter(noSonarFilter, "noSonarFilter");
        Intrinsics.checkNotNullParameter((Object)language, "language");
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.language = language;
        Checks checks3 = checks2 = checkFactory.create("kotlin");
        KotlinSensor kotlinSensor = this;
        boolean bl = false;
        List<Class<? extends AbstractCheck>> list2 = KotlinCheckListKt.getKOTLIN_CHECKS();
        Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.Iterable<*>");
        $this$checks_u24lambda_u2d1.addAnnotatedChecks((Iterable)list2);
        Collection collection = $this$checks_u24lambda_u2d1.all();
        Intrinsics.checkNotNullExpressionValue(collection, "all()");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractCheck it = (AbstractCheck)element$iv;
            boolean bl2 = false;
            RuleKey ruleKey = $this$checks_u24lambda_u2d1.ruleKey((Object)it);
            Intrinsics.checkNotNull(ruleKey);
            it.initialize(ruleKey);
        }
        Checks checks4 = checks2;
        Intrinsics.checkNotNullExpressionValue(checks4, "checkFactory.create<Abst\u2026ze(ruleKey(it)!!) }\n    }");
        kotlinSensor.checks = checks4;
    }

    @NotNull
    public final KotlinLanguage getLanguage() {
        return this.language;
    }

    @NotNull
    public final Checks<AbstractCheck> getChecks() {
        return this.checks;
    }

    public void describe(@NotNull SensorDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        descriptor2.onlyOnLanguage(this.language.getKey()).name(this.language.getName() + " Sensor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute(@NotNull SensorContext sensorContext) {
        block9: {
            void $this$mapTo$iv$iv;
            Iterable filesToAnalyze;
            Iterable iterable;
            Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
            PerformanceMeasure.Duration sensorDuration = KotlinSensorKt.access$createPerformanceMeasureReport(sensorContext);
            FileSystem fileSystem2 = sensorContext.fileSystem();
            Intrinsics.checkNotNullExpressionValue(fileSystem2, "sensorContext.fileSystem()");
            FileSystem fileSystem3 = fileSystem2;
            FilePredicate mainFilePredicate = fileSystem3.predicates().and(fileSystem3.predicates().hasLanguage(this.language.getKey()), fileSystem3.predicates().hasType(InputFile.Type.MAIN));
            Iterable mainFiles = fileSystem3.inputFiles(mainFilePredicate);
            boolean $i$a$-let-KotlinSensor$execute$filesToAnalyze$22 = false;
            if (this.canSkipUnchangedFiles(sensorContext) && sensorContext.runtime().getProduct() != SonarProduct.SONARLINT) {
                Object object;
                void $this$filterTo$iv$iv;
                ContentHashCache contentHashCache = ContentHashCache.Companion.of(sensorContext);
                KotlinSensorKt.access$getLOG$p().debug("The Kotlin analyzer is running in a context where it can skip unchanged files.");
                int totalFiles = 0;
                Intrinsics.checkNotNullExpressionValue(mainFiles, "mainFiles");
                Iterable $this$filter$iv = mainFiles;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    InputFile it = (InputFile)element$iv$iv;
                    boolean bl = false;
                    ++totalFiles;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    if (!(this.fileHasChanged(it, contentHashCache) || !this.reuseCPDTokens(it, sensorContext))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Object it = object = (List)destination$iv$iv;
                boolean bl = false;
                KotlinSensorKt.access$getLOG$p().info("Only analyzing " + it.size() + " changed Kotlin files out of " + totalFiles + ".");
                iterable = (Iterable)object;
            } else {
                KotlinSensorKt.access$getLOG$p().debug("The Kotlin analyzer is running in a context where unchanged files cannot be skipped.");
                iterable = mainFiles;
            }
            Intrinsics.checkNotNullExpressionValue(iterable, "fileSystem.inputFiles(ma\u2026s\n            }\n        }");
            Iterable $this$map$iv = filesToAnalyze = iterable;
            boolean $i$f$map = false;
            Iterable $i$a$-let-KotlinSensor$execute$filesToAnalyze$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InputFile bl = (InputFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.toString());
            }
            List filenames = (List)destination$iv$iv;
            if (filenames.isEmpty()) {
                return;
            }
            ProgressReport progressReport = new ProgressReport("Progress of the " + this.language.getName() + " analysis", TimeUnit.SECONDS.toMillis(10L));
            boolean success = false;
            try {
                success = this.analyseFiles(sensorContext, filesToAnalyze, progressReport, this.visitors(sensorContext), filenames);
                if (success) {
                    progressReport.stop();
                } else {
                    progressReport.cancel();
                }
            }
            catch (Throwable throwable) {
                progressReport.cancel();
                throw throwable;
            }
            PerformanceMeasure.Duration duration = sensorDuration;
            if (duration == null) break block9;
            duration.stop();
        }
    }

    private final boolean reuseCPDTokens(InputFile inputFile, SensorContext sensorContext) {
        boolean bl;
        if (!ApiExtensionsKt.hasCacheEnabled(sensorContext)) {
            return false;
        }
        ReadCache previousCache = sensorContext.previousCache();
        Intrinsics.checkNotNullExpressionValue(previousCache, "previousCache");
        List<CPDToken> list2 = CachingKt.loadCPDTokens(previousCache, inputFile);
        if (list2 != null) {
            NewCpdTokens newCpdTokens;
            List<CPDToken> previousTokens = list2;
            boolean bl2 = false;
            NewCpdTokens $this$reuseCPDTokens_u24lambda_u2d8_u24lambda_u2d7 = newCpdTokens = sensorContext.newCpdTokens().onFile(inputFile);
            boolean bl3 = false;
            Iterable $this$forEach$iv = previousTokens;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CPDToken it = (CPDToken)element$iv;
                boolean bl4 = false;
                $this$reuseCPDTokens_u24lambda_u2d8_u24lambda_u2d7.addToken(it.getRange(), it.getText());
            }
            $this$reuseCPDTokens_u24lambda_u2d8_u24lambda_u2d7.save();
            WriteCache nextCache = sensorContext.nextCache();
            try {
                Intrinsics.checkNotNullExpressionValue(nextCache, "nextCache");
                CachingKt.copyCPDTokensFromPrevious(nextCache, inputFile);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                KotlinSensorKt.access$getLOG$p().trace("Unable to save the CPD tokens of file " + inputFile + " for the next analysis.");
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean canSkipUnchangedFiles(SensorContext sensorContext) {
        Object object;
        Optional optional = sensorContext.config().getBoolean("sonar.kotlin.skipUnchanged");
        Intrinsics.checkNotNullExpressionValue(optional, "sensorContext.config().g\u2026UNCHANGED_FILES_OVERRIDE)");
        Optional $this$getOrElse$iv = optional;
        boolean $i$f$getOrElse = false;
        if ($this$getOrElse$iv.isPresent()) {
            object = $this$getOrElse$iv.get();
        } else {
            boolean bl;
            boolean bl2 = false;
            try {
                bl = sensorContext.canSkipUnchangedFiles();
            }
            catch (IncompatibleClassChangeError incompatibleClassChangeError) {
                bl = false;
            }
            object = bl;
        }
        return (Boolean)object;
    }

    private final boolean fileHasChanged(InputFile inputFile, ContentHashCache contentHashCache) {
        ContentHashCache contentHashCache2 = contentHashCache;
        return contentHashCache2 != null ? contentHashCache2.hasDifferentContentCached(inputFile) : inputFile.status() != InputFile.Status.SAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final boolean analyseFiles(SensorContext sensorContext, Iterable<? extends InputFile> inputFiles, ProgressReport progressReport, List<? extends KotlinFileVisitor> visitors, List<String> filenames) {
        Environment environment = KotlinSensorKt.environment(sensorContext);
        try {
            Object object;
            Object $this$analyseFiles_u24lambda_u2d11;
            void $this$mapNotNullTo$iv$iv;
            boolean isInAndroidContext = KotlinPluginKt.isInAndroidContext(environment);
            Iterable<? extends InputFile> $this$mapNotNull$iv = inputFiles;
            boolean $i$f$mapNotNull22 = false;
            Iterable<? extends InputFile> iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KotlinSyntaxStructure it$iv$iv;
                KotlinSyntaxStructure kotlinSyntaxStructure;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                InputFile it = (InputFile)element$iv$iv;
                boolean bl2 = false;
                InputFileContextImpl inputFileContext = new InputFileContextImpl(sensorContext, it, isInAndroidContext);
                try {
                    String string2 = it.contents();
                    Intrinsics.checkNotNullExpressionValue(string2, "it.contents()");
                    kotlinSyntaxStructure = KotlinSyntaxStructure.Companion.of(string2, environment, it);
                }
                catch (ParseException e) {
                    this.logParsingError(it, KotlinSensorKt.access$toParseException("parse", it, e));
                    inputFileContext.reportAnalysisParseError("kotlin", it, e.getPosition());
                    kotlinSyntaxStructure = null;
                }
                catch (Exception e) {
                    ParseException parseException = KotlinSensorKt.access$toParseException("read", it, e);
                    this.logParsingError(it, parseException);
                    inputFileContext.reportAnalysisParseError("kotlin", it, parseException.getPosition());
                    kotlinSyntaxStructure = null;
                }
                if (kotlinSyntaxStructure == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List kotlinFiles = (List)destination$iv$iv;
            Object $i$f$mapNotNull22 = this;
            try {
                $this$analyseFiles_u24lambda_u2d11 = $i$f$mapNotNull22;
                boolean bl = false;
                $this$analyseFiles_u24lambda_u2d11 = Result.constructor-impl((BindingContext)MetricsUtilsKt.measureDuration("BindingContext", (Function0)new Function0<BindingContext>(environment, (List<KotlinSyntaxStructure>)kotlinFiles){
                    final /* synthetic */ Environment $environment;
                    final /* synthetic */ List<KotlinSyntaxStructure> $kotlinFiles;
                    {
                        this.$environment = $environment;
                        this.$kotlinFiles = $kotlinFiles;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final BindingContext invoke() {
                        Collection<KtFile> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = this.$kotlinFiles;
                        List<String> list2 = this.$environment.getClasspath();
                        KotlinCoreEnvironment kotlinCoreEnvironment = this.$environment.getEnv();
                        boolean $i$f$map = false;
                        void var3_5 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            KotlinSyntaxStructure kotlinSyntaxStructure = (KotlinSyntaxStructure)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getKtFile());
                        }
                        collection = (List)destination$iv$iv;
                        return KotlinCoreEnvironmentToolsKt.bindingContext(kotlinCoreEnvironment, list2, (List<? extends KtFile>)collection);
                    }
                }));
            }
            catch (Throwable bl) {
                $this$analyseFiles_u24lambda_u2d11 = Result.constructor-impl(ResultKt.createFailure(bl));
            }
            $i$f$mapNotNull22 = $this$analyseFiles_u24lambda_u2d11;
            Throwable throwable = Result.exceptionOrNull-impl($i$f$mapNotNull22);
            if (throwable == null) {
                object = $i$f$mapNotNull22;
            } else {
                Throwable e = throwable;
                boolean bl = false;
                KotlinSensorKt.access$getLOG$p().error("Could not generate binding context. Proceeding without semantics.", e);
                object = BindingContext.EMPTY;
            }
            BindingContext bindingContext2 = (BindingContext)object;
            Map diagnostics2 = (Map)MetricsUtilsKt.measureDuration("Diagnostics", (Function0)new Function0<Map<PsiFile, ? extends List<? extends Diagnostic>>>(bindingContext2){
                final /* synthetic */ BindingContext $bindingContext;
                {
                    this.$bindingContext = $bindingContext;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Map<PsiFile, List<Diagnostic>> invoke() {
                    void $this$groupByTo$iv$iv;
                    Iterable $this$groupBy$iv = this.$bindingContext.getDiagnostics().noSuppression();
                    boolean $i$f$groupBy = false;
                    Iterable iterable = $this$groupBy$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>();
                    boolean $i$f$groupByTo = false;
                    for (T element$iv$iv : $this$groupByTo$iv$iv) {
                        Object object;
                        Diagnostic it = (Diagnostic)element$iv$iv;
                        boolean bl = false;
                        PsiFile key$iv$iv = it.getPsiFile();
                        Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                        boolean $i$f$getOrPut = false;
                        V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            boolean bl2 = false;
                            List answer$iv$iv$iv = new ArrayList<E>();
                            $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    return MapsKt.toMap(destination$iv$iv);
                }
            });
            RegexCache regexCache = new RegexCache(null, 1, null);
            progressReport.start((Iterable<String>)filenames);
            for (KotlinSyntaxStructure kotlinSyntaxStructure : kotlinFiles) {
                KtFile ktFile = kotlinSyntaxStructure.component1();
                Document doc = kotlinSyntaxStructure.component2();
                InputFile inputFile = kotlinSyntaxStructure.component3();
                if (sensorContext.isCancelled()) {
                    boolean element$iv$iv$iv = false;
                    return element$iv$iv$iv;
                }
                InputFileContextImpl inputFileContext = new InputFileContextImpl(sensorContext, inputFile, isInAndroidContext);
                String string3 = inputFile.filename();
                Intrinsics.checkNotNullExpressionValue(string3, "inputFile.filename()");
                MetricsUtilsKt.measureDuration(string3, (Function0)new Function0<Unit>(this, sensorContext, inputFileContext, visitors, ktFile, doc, bindingContext2, (Map<PsiFile, ? extends List<? extends Diagnostic>>)diagnostics2, regexCache){
                    final /* synthetic */ KotlinSensor this$0;
                    final /* synthetic */ SensorContext $sensorContext;
                    final /* synthetic */ InputFileContextImpl $inputFileContext;
                    final /* synthetic */ List<KotlinFileVisitor> $visitors;
                    final /* synthetic */ KtFile $ktFile;
                    final /* synthetic */ Document $doc;
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ Map<PsiFile, List<Diagnostic>> $diagnostics;
                    final /* synthetic */ RegexCache $regexCache;
                    {
                        this.this$0 = $receiver;
                        this.$sensorContext = $sensorContext;
                        this.$inputFileContext = $inputFileContext;
                        this.$visitors = $visitors;
                        this.$ktFile = $ktFile;
                        this.$doc = $doc;
                        this.$bindingContext = $bindingContext;
                        this.$diagnostics = $diagnostics;
                        this.$regexCache = $regexCache;
                        super(0);
                    }

                    public final void invoke() {
                        InputFileContext inputFileContext = this.$inputFileContext;
                        BindingContext bindingContext2 = this.$bindingContext;
                        Intrinsics.checkNotNullExpressionValue(bindingContext2, "bindingContext");
                        List<Diagnostic> list2 = this.$diagnostics.get(this.$ktFile);
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        KotlinSensor.access$analyseFile(this.this$0, this.$sensorContext, inputFileContext, this.$visitors, new KotlinTree(this.$ktFile, this.$doc, bindingContext2, list2, this.$regexCache));
                    }
                });
                progressReport.nextFile();
            }
        }
        finally {
            Disposer.dispose(environment.getDisposable());
        }
        return true;
    }

    private final void analyseFile(SensorContext sensorContext, InputFileContext inputFileContext, List<? extends KotlinFileVisitor> visitors, KotlinTree tree) {
        Regex regex = KotlinSensorKt.access$getEMPTY_FILE_CONTENT_PATTERN$p();
        String string2 = inputFileContext.getInputFile().contents();
        Intrinsics.checkNotNullExpressionValue(string2, "inputFileContext.inputFile.contents()");
        if (regex.matches(string2)) {
            return;
        }
        this.visitFile(sensorContext, inputFileContext, visitors, tree);
    }

    private final void visitFile(SensorContext sensorContext, InputFileContext inputFileContext, List<? extends KotlinFileVisitor> visitors, KotlinTree tree) {
        for (KotlinFileVisitor kotlinFileVisitor : visitors) {
            String visitorId = kotlinFileVisitor.getClass().getSimpleName();
            try {
                Intrinsics.checkNotNullExpressionValue(visitorId, "visitorId");
                MetricsUtilsKt.measureDuration(visitorId, (Function0)new Function0<Unit>(kotlinFileVisitor, inputFileContext, tree){
                    final /* synthetic */ KotlinFileVisitor $visitor;
                    final /* synthetic */ InputFileContext $inputFileContext;
                    final /* synthetic */ KotlinTree $tree;
                    {
                        this.$visitor = $visitor;
                        this.$inputFileContext = $inputFileContext;
                        this.$tree = $tree;
                        super(0);
                    }

                    public final void invoke() {
                        this.$visitor.scan(this.$inputFileContext, this.$tree);
                    }
                });
            }
            catch (Exception e) {
                inputFileContext.reportAnalysisError(e.getMessage(), null);
                KotlinSensorKt.access$getLOG$p().error("Cannot analyse '" + inputFileContext.getInputFile() + "' with '" + visitorId + "': " + e.getMessage(), (Throwable)e);
                Boolean bl = sensorContext.config().getBoolean("sonar.internal.analysis.failFast").orElse(false);
                Intrinsics.checkNotNullExpressionValue(bl, "sensorContext.config().g\u2026PERTY_NAME).orElse(false)");
                if (!bl.booleanValue()) continue;
                throw new IllegalStateException("Exception in '" + visitorId + "' while analyzing '" + inputFileContext.getInputFile() + "'", e);
            }
        }
    }

    private final List<KotlinFileVisitor> visitors(SensorContext sensorContext) {
        List<KotlinFileVisitor> list2;
        if (sensorContext.runtime().getProduct() == SonarProduct.SONARLINT) {
            KotlinFileVisitor[] kotlinFileVisitorArray = new KotlinFileVisitor[]{new IssueSuppressionVisitor(), new KtChecksVisitor(this.checks)};
            list2 = CollectionsKt.listOf(kotlinFileVisitorArray);
        } else {
            KotlinFileVisitor[] kotlinFileVisitorArray = new KotlinFileVisitor[]{new IssueSuppressionVisitor(), new MetricVisitor(this.fileLinesContextFactory, this.noSonarFilter), new KtChecksVisitor(this.checks), new CopyPasteDetector(), new SyntaxHighlighter()};
            list2 = CollectionsKt.listOf(kotlinFileVisitorArray);
        }
        return list2;
    }

    private final void logParsingError(InputFile inputFile, ParseException e) {
        block1: {
            TextPointer position = e.getPosition();
            Object positionMessage = "";
            if (position != null) {
                positionMessage = "Parse error at position " + position.line() + ":" + position.lineOffset();
            }
            KotlinSensorKt.access$getLOG$p().error("Unable to parse file: " + inputFile.uri() + ". " + (String)positionMessage);
            String string2 = e.getMessage();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            KotlinSensorKt.access$getLOG$p().error(it);
        }
    }

    public static final /* synthetic */ void access$analyseFile(KotlinSensor $this, SensorContext sensorContext, InputFileContext inputFileContext, List visitors, KotlinTree tree) {
        $this.analyseFile(sensorContext, inputFileContext, visitors, tree);
    }
}

