/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.SecondaryLocation;
import org.sonarsource.kotlin.converter.KotlinTextRanges;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S107")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/sonarsource/kotlin/checks/TooManyParametersCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "exceptionsList", "", "", "max", "", "getMax", "()I", "setMax", "(I)V", "report", "", "reportingLocation", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "parameters", "Lorg/jetbrains/kotlin/psi/KtParameter;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "visitFunctionType", "type", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Companion", "sonar-kotlin-plugin"})
public final class TooManyParametersCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RuleProperty(key="Max", description="Maximum authorized number of parameters", defaultValue="7")
    private int max = 7;
    @NotNull
    private final List<String> exceptionsList;
    public static final int DEFAULT_MAX = 7;

    public TooManyParametersCheck() {
        String[] stringArray = new String[]{"RequestMapping", "GetMapping", "PostMapping", "PutMapping", "DeleteMapping", "PatchMapping", "JsonCreator"};
        this.exceptionsList = CollectionsKt.listOf(stringArray);
    }

    public final int getMax() {
        return this.max;
    }

    public final void setMax(int n) {
        this.max = n;
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (function2.getValueParameters().size() > this.max && !function2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            boolean bl;
            block6: {
                List<KtAnnotationEntry> list2 = function2.getAnnotationEntries();
                Intrinsics.checkNotNullExpressionValue(list2, "function.annotationEntries");
                Iterable $this$none$iv = list2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                        boolean bl2 = false;
                        Name name = it.getShortName();
                        if (!CollectionsKt.contains((Iterable)this.exceptionsList, name != null ? name.asString() : null)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                PsiElement psiElement = function2.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = function2;
                }
                List<KtParameter> list3 = function2.getValueParameters();
                Intrinsics.checkNotNullExpressionValue(list3, "function.valueParameters");
                this.report(psiElement, list3, kotlinFileContext);
            }
        }
    }

    @Override
    public void visitFunctionType(@NotNull KtFunctionType type2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (type2.getParameters().size() > this.max) {
            PsiElement psiElement = type2;
            List<KtParameter> list2 = type2.getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "type.parameters");
            this.report(psiElement, list2, kotlinFileContext);
        }
    }

    private final void report(PsiElement reportingLocation, List<? extends KtParameter> parameters2, KotlinFileContext kotlinFileContext) {
        AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)this, kotlinFileContext, reportingLocation, "This function has " + parameters2.size() + " parameters, which is greater than the " + this.max + " authorized.", SequencesKt.toList(SequencesKt.map(SequencesKt.drop(CollectionsKt.asSequence((Iterable)parameters2), this.max), (Function1)new Function1<KtParameter, SecondaryLocation>(kotlinFileContext){
            final /* synthetic */ KotlinFileContext $kotlinFileContext;
            {
                this.$kotlinFileContext = $kotlinFileContext;
                super(1);
            }

            @NotNull
            public final SecondaryLocation invoke(@NotNull KtParameter it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(this.$kotlinFileContext, it), null);
            }
        })), null, 8, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/sonarsource/kotlin/checks/TooManyParametersCheck$Companion;", "", "()V", "DEFAULT_MAX", "", "sonar-kotlin-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

