/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.api.CallAbstractCheck;
import org.sonarsource.kotlin.api.FunMatcherImpl;
import org.sonarsource.kotlin.api.FunMatcherKt;
import org.sonarsource.kotlin.checks.IsInstanceMethodCheck;
import org.sonarsource.kotlin.checks.IsInstanceMethodCheckKt;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S6202")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\t*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0018*\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\tH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/sonarsource/kotlin/checks/IsInstanceMethodCheck;", "Lorg/sonarsource/kotlin/api/CallAbstractCheck;", "()V", "functionsToVisit", "", "Lorg/sonarsource/kotlin/api/FunMatcherImpl;", "getFunctionsToVisit", "()Ljava/util/List;", "isJavaClassKeyword", "", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitFunctionCall", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "isClass", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "ctx", "qualifiedName", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "onlyClass", "qualifiedNameWithoutJavaClassKeyword", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "sonar-kotlin-plugin"})
public final class IsInstanceMethodCheck
extends CallAbstractCheck {
    @NotNull
    private final List<FunMatcherImpl> functionsToVisit;

    public IsInstanceMethodCheck() {
        FunMatcherImpl[] funMatcherImplArray = new FunMatcherImpl[]{FunMatcherKt.FunMatcher$default("kotlin.reflect.KClass", "isInstance", null, null, null, null, false, null, null, null, null, functionsToVisit.1.INSTANCE, 2044, null), FunMatcherKt.FunMatcher$default("java.lang.Class", "isInstance", null, null, null, null, false, null, null, null, null, functionsToVisit.2.INSTANCE, 2044, null)};
        this.functionsToVisit = CollectionsKt.listOf(funMatcherImplArray);
    }

    @NotNull
    public List<FunMatcherImpl> getFunctionsToVisit() {
        return this.functionsToVisit;
    }

    @Override
    public void visitFunctionCall(@NotNull KtCallExpression callExpression, @NotNull ResolvedCall<?> resolvedCall2, @NotNull KotlinFileContext kotlinFileContext) {
        block0: {
            Intrinsics.checkNotNullParameter(callExpression, "callExpression");
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(callExpression);
            String string2 = this.qualifiedName(ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null, kotlinFileContext, true);
            if (string2 == null) break block0;
            String className = string2;
            boolean bl = false;
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = callExpression.getCalleeExpression();
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$sonar_kotlin_plugin$default(abstractCheck, kotlinFileContext, ktExpression, "Replace this usage of \"isInstance\" with \"is " + className + "\".", null, null, 12, null);
        }
    }

    private final String qualifiedName(PsiElement $this$qualifiedName, KotlinFileContext ctx, boolean onlyClass) {
        Object object;
        KtExpression expr = KtPsiUtil.deparenthesize($this$qualifiedName instanceof KtExpression ? (KtExpression)$this$qualifiedName : null);
        if (expr instanceof KtClassLiteralExpression) {
            object = onlyClass ? this.qualifiedName(((KtClassLiteralExpression)expr).getLhs(), ctx, true) : null;
        } else if (expr instanceof KtNameReferenceExpression) {
            object = !onlyClass || this.isClass((KtReferenceExpression)expr, ctx) ? ((KtNameReferenceExpression)expr).getReferencedName() : null;
        } else if (expr instanceof KtDotQualifiedExpression) {
            String right = this.qualifiedName(((KtDotQualifiedExpression)expr).getSelectorExpression(), ctx, onlyClass);
            if (right != null) {
                String string2 = this.qualifiedName(((KtDotQualifiedExpression)expr).getReceiverExpression(), ctx, false);
                if (string2 != null) {
                    String left = string2;
                    boolean bl = false;
                    object = left + "." + right;
                } else {
                    object = null;
                }
            } else {
                object = this.qualifiedNameWithoutJavaClassKeyword((KtDotQualifiedExpression)expr, ctx, onlyClass);
            }
        } else {
            object = null;
        }
        return object;
    }

    private final String qualifiedNameWithoutJavaClassKeyword(KtDotQualifiedExpression $this$qualifiedNameWithoutJavaClassKeyword, KotlinFileContext ctx, boolean onlyClass) {
        return onlyClass && this.isJavaClassKeyword($this$qualifiedNameWithoutJavaClassKeyword.getSelectorExpression()) ? this.qualifiedName($this$qualifiedNameWithoutJavaClassKeyword.getReceiverExpression(), ctx, true) : null;
    }

    private final boolean isJavaClassKeyword(KtExpression expr) {
        return expr instanceof KtNameReferenceExpression && IsInstanceMethodCheckKt.access$getJAVA_CLASS_KEYWORDS$p().contains(((KtNameReferenceExpression)expr).getReferencedName());
    }

    private final boolean isClass(KtReferenceExpression $this$isClass, KotlinFileContext ctx) {
        return ctx.getBindingContext().get(BindingContext.REFERENCE_TARGET, $this$isClass) instanceof ClassDescriptor;
    }
}

