/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.AbstractCheck;
import org.sonarsource.kotlin.checks.FixMeCommentCheckKt;
import org.sonarsource.kotlin.converter.KotlinTextRanges;
import org.sonarsource.kotlin.plugin.KotlinFileContext;

@Rule(key="S1134")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/sonarsource/kotlin/checks/FixMeCommentCheck;", "Lorg/sonarsource/kotlin/api/AbstractCheck;", "()V", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlinFileContext", "Lorg/sonarsource/kotlin/plugin/KotlinFileContext;", "sonar-kotlin-plugin"})
public final class FixMeCommentCheck
extends AbstractCheck {
    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        file2.accept(new KtTreeVisitorVoid(kotlinFileContext, this){
            final /* synthetic */ KotlinFileContext $kotlinFileContext;
            final /* synthetic */ FixMeCommentCheck this$0;
            {
                this.$kotlinFileContext = $kotlinFileContext;
                this.this$0 = $receiver;
            }

            public void visitElement(@NotNull PsiElement element) {
                block1: {
                    Intrinsics.checkNotNullParameter(element, "element");
                    super.visitElement(element);
                    if (!(element instanceof PsiComment)) {
                        return;
                    }
                    Regex regex = FixMeCommentCheckKt.getFixMePattern();
                    String string2 = ((PsiComment)element).getText();
                    Intrinsics.checkNotNullExpressionValue(string2, "element.text");
                    MatchResult matchResult = Regex.find$default(regex, string2, 0, 2, null);
                    if (matchResult == null) break block1;
                    MatchResult matchResult2 = matchResult;
                    KotlinFileContext kotlinFileContext = this.$kotlinFileContext;
                    FixMeCommentCheck fixMeCommentCheck = this.this$0;
                    MatchResult matchResult3 = matchResult2;
                    boolean bl = false;
                    int n = ((PsiComment)element).getTextOffset();
                    MatchGroup matchGroup = matchResult3.getGroups().get(2);
                    Intrinsics.checkNotNull(matchGroup);
                    int fixmeOffset = n + matchGroup.getRange().getFirst();
                    Document document = kotlinFileContext.getKtFile().getViewProvider().getDocument();
                    Intrinsics.checkNotNull(document);
                    Document document2 = document;
                    InputFile inputFile = kotlinFileContext.getInputFileContext().getInputFile();
                    TextRange fixmeRange = inputFile.newRange(KotlinTextRanges.INSTANCE.textPointerAtOffset(inputFile, document2, fixmeOffset), KotlinTextRanges.INSTANCE.textPointerAtOffset(inputFile, document2, fixmeOffset + 5));
                    AbstractCheck.reportIssue$sonar_kotlin_plugin$default((AbstractCheck)fixMeCommentCheck, kotlinFileContext, fixmeRange, "Take the required action to fix the issue indicated by this \"FIXME\" comment.", null, null, 12, null);
                }
            }
        });
    }
}

