/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.plugin;

import com.sonar.sslr.api.RecognitionException;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Language;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.IacSensor;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.terraform.checks.TerraformCheckList;
import org.sonar.iac.terraform.parser.HclParser;
import org.sonar.iac.terraform.plugin.TerraformLanguage;
import org.sonar.iac.terraform.plugin.TerraformProviders;
import org.sonar.iac.terraform.visitors.TerraformChecksVisitor;
import org.sonar.iac.terraform.visitors.TerraformHighlightingVisitor;
import org.sonar.iac.terraform.visitors.TerraformMetricsVisitor;

public class TerraformSensor
extends IacSensor {
    private final Checks<IacCheck> checks;
    private final TerraformProviders providerVersions;

    public TerraformSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, TerraformLanguage language, TerraformProviders providerVersions) {
        super(sonarRuntime, fileLinesContextFactory, noSonarFilter, (Language)language);
        this.checks = checkFactory.create("terraform");
        this.checks.addAnnotatedChecks(TerraformCheckList.checks());
        this.providerVersions = providerVersions;
    }

    protected HclParser treeParser() {
        return new HclParser();
    }

    @Override
    protected String repositoryKey() {
        return "terraform";
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        ArrayList<TreeVisitor<InputFileContext>> visitors = new ArrayList<TreeVisitor<InputFileContext>>();
        if (this.isSonarLintContext(sensorContext)) {
            visitors.add(new TerraformMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter));
            visitors.add(new TerraformHighlightingVisitor());
        }
        visitors.add(new TerraformChecksVisitor(this.checks, statistics, this.providerVersions));
        return visitors;
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.terraform.activate";
    }

    @Override
    protected ParseException toParseException(String action, InputFile inputFile, Exception cause) {
        TextPointer position = null;
        if (cause instanceof RecognitionException) {
            position = inputFile.newPointer(((RecognitionException)cause).getLine(), 0);
        }
        return new ParseException("Cannot " + action + " '" + inputFile + "': " + cause.getMessage(), position);
    }
}

