/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.Policy;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.extension.visitors.TreeContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.FunctionCallTree;
import org.sonar.iac.terraform.api.tree.SeparatedTrees;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.api.tree.TupleTree;

public class PolicyUtils {
    public static final Policy UNKNOWN_POLCY = new Policy(null, t -> Collections.emptyList());

    private PolicyUtils() {
    }

    public static List<Policy> getPolicies(Tree root) {
        PolicyCollector collector = new PolicyCollector();
        collector.scan(new TreeContext(), root);
        return collector.policies;
    }

    private static class PolicyCollector
    extends TreeVisitor<TreeContext> {
        private final List<Policy> policies = new ArrayList<Policy>();

        private PolicyCollector() {
            this.register(BlockTree.class, (ctx, tree) -> this.collectPolicy((BlockTree)tree));
        }

        private void collectPolicy(BlockTree tree) {
            Optional<Tree> policyDocument = PolicyCollector.findPolicyDocument(tree);
            if (policyDocument.isPresent()) {
                Tree policyExpr = policyDocument.get();
                if (!(policyExpr instanceof FunctionCallTree) || ((FunctionCallTree)policyExpr).arguments().trees().isEmpty()) {
                    this.policies.add(UNKNOWN_POLCY);
                    return;
                }
                TerraformTree policyArgument = ((FunctionCallTree)policyExpr).arguments().trees().get(0);
                this.policies.add(new Policy(policyArgument, policy -> PropertyUtils.value(policy, "Statement", TupleTree.class).map(TupleTree::elements).map(SeparatedTrees::treesAndSeparators).orElse(Collections.emptyList())));
            }
        }

        private static Optional<Tree> findPolicyDocument(BlockTree tree) {
            return PropertyUtils.value((Tree)tree, key -> key.contains("policy"));
        }
    }
}

