/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.symbols;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.api.tree.TupleTree;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.Symbol;

public class ListSymbol
extends Symbol<AttributeTree> {
    private final List<ExpressionTree> items;

    private ListSymbol(CheckContext ctx, AttributeTree tree, String name, BlockSymbol parent, List<ExpressionTree> items) {
        super(ctx, tree, name, parent);
        this.items = items;
    }

    public static ListSymbol fromPresent(CheckContext ctx, AttributeTree tree, BlockSymbol parent) {
        if (tree.value().is(TerraformTree.Kind.TUPLE)) {
            return new ListSymbol(ctx, tree, tree.key().value(), parent, ((TupleTree)tree.value()).elements().trees());
        }
        return ListSymbol.fromAbsent(ctx, tree.key().value(), parent);
    }

    public static ListSymbol fromAbsent(CheckContext ctx, String name, BlockSymbol parent) {
        return new ListSymbol(ctx, null, name, parent, Collections.emptyList());
    }

    public ListSymbol reportItemIf(Predicate<ExpressionTree> predicate, String message, SecondaryLocation ... secondaryLocations) {
        this.items.stream().filter(predicate).forEach(item -> this.ctx.reportIssue((HasTextRange)item, message, List.of(secondaryLocations)));
        return this;
    }

    public Stream<ExpressionTree> getItemIf(Predicate<ExpressionTree> predicate) {
        return this.items.stream().filter(predicate);
    }

    public boolean isEmpty() {
        return this.tree != null && this.items.isEmpty();
    }

    @Override
    @Nullable
    protected HasTextRange toHighlight() {
        return this.tree != null ? ((AttributeTree)this.tree).key() : null;
    }
}

