/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6403")
public class DatabaseIpConfigCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure creating a GCP SQL instance without requiring TLS is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting %s allows unencrypted connections to the database. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("google_sql_database_instance", (ResourceSymbol resource) -> resource.block("settings").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]).block("ip_configuration").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]).attribute("require_ssl").reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]).reportIf(ExpressionPredicate.isFalse(), MESSAGE, new SecondaryLocation[0]));
    }
}

