/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.Optional;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.utils.PredicateUtils;

@Rule(key="S6382")
public class CertificateBasedAuthenticationCheck
extends AbstractResourceCheck {
    private static final String MESSAGE_WHEN_DISABLED = "Make sure that disabling certificate-based authentication is safe here.";
    private static final String TEMPLATE_WHEN_MISSING = "Omitting %s disables certificate-based authentication. Make sure it is safe here.";
    private static final String CLIENT_CERT_MODE = "client_cert_mode";
    private static final String CLIENT_CERT_ENABLED = "client_cert_enabled";
    private static final Predicate<String> CONSUMPTION_PATTERN = PredicateUtils.exactMatchStringPredicate("Consumption_[0-9]+", 2);

    private static String messageWhenMissing(String propName) {
        return String.format(TEMPLATE_WHEN_MISSING, propName);
    }

    @Override
    protected void registerResourceChecks() {
        this.register(CertificateBasedAuthenticationCheck::checkAppService, "azurerm_app_service");
        this.register(CertificateBasedAuthenticationCheck::checkApps, "azurerm_function_app", "azurerm_logic_app_standard");
        this.register(CertificateBasedAuthenticationCheck::checkWebApps, "azurerm_linux_web_app", "azurerm_windows_web_app");
        this.register(CertificateBasedAuthenticationCheck::checkApiManagement, "azurerm_api_management");
        this.register(CertificateBasedAuthenticationCheck::checkLinkedServices, "azurerm_data_factory_linked_service_sftp", "azurerm_data_factory_linked_service_web");
    }

    private static void checkAppService(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, CLIENT_CERT_ENABLED, AttributeTree.class).ifPresentOrElse(m -> CertificateBasedAuthenticationCheck.reportOnFalse(ctx, m, MESSAGE_WHEN_DISABLED, new SecondaryLocation[0]), () -> CertificateBasedAuthenticationCheck.reportResource(ctx, resource, CertificateBasedAuthenticationCheck.messageWhenMissing(CLIENT_CERT_ENABLED)));
    }

    private static void checkApps(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, CLIENT_CERT_MODE, AttributeTree.class).ifPresentOrElse(m -> CertificateBasedAuthenticationCheck.reportSensitiveValue(ctx, m, "Optional", MESSAGE_WHEN_DISABLED, new SecondaryLocation[0]), () -> CertificateBasedAuthenticationCheck.reportResource(ctx, resource, CertificateBasedAuthenticationCheck.messageWhenMissing(CLIENT_CERT_MODE)));
    }

    private static void checkWebApps(CheckContext ctx, BlockTree resource) {
        Optional<AttributeTree> optCertEnabled = PropertyUtils.get(resource, CLIENT_CERT_ENABLED, AttributeTree.class);
        if (optCertEnabled.isEmpty()) {
            CertificateBasedAuthenticationCheck.reportResource(ctx, resource, CertificateBasedAuthenticationCheck.messageWhenMissing(CLIENT_CERT_ENABLED));
        } else if (TextUtils.isValueFalse(optCertEnabled.get().value())) {
            ctx.reportIssue(optCertEnabled.get(), MESSAGE_WHEN_DISABLED);
        } else {
            PropertyUtils.get(resource, CLIENT_CERT_MODE, AttributeTree.class).ifPresentOrElse(m -> CertificateBasedAuthenticationCheck.reportSensitiveValue(ctx, m, "Optional", MESSAGE_WHEN_DISABLED, new SecondaryLocation[0]), () -> CertificateBasedAuthenticationCheck.reportResource(ctx, resource, CertificateBasedAuthenticationCheck.messageWhenMissing(CLIENT_CERT_MODE)));
        }
    }

    private static void checkApiManagement(CheckContext ctx, BlockTree resource) {
        Optional<Tree> optSkuName = PropertyUtils.value((Tree)resource, "sku_name");
        if (optSkuName.isPresent() && TextUtils.matchesValue(optSkuName.get(), CONSUMPTION_PATTERN).isTrue()) {
            PropertyUtils.get(resource, "client_certificate_enabled", AttributeTree.class).ifPresentOrElse(m -> CertificateBasedAuthenticationCheck.reportOnFalse(ctx, m, MESSAGE_WHEN_DISABLED, new SecondaryLocation[0]), () -> CertificateBasedAuthenticationCheck.reportResource(ctx, resource, CertificateBasedAuthenticationCheck.messageWhenMissing("client_certificate_enabled")));
        }
    }

    private static void checkLinkedServices(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "authentication_type", AttributeTree.class).ifPresent(m -> CertificateBasedAuthenticationCheck.reportSensitiveValue(ctx, m, "Basic", MESSAGE_WHEN_DISABLED, new SecondaryLocation[0]));
    }
}

