/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class AzureClearTextProtocolsCheckPart
extends AbstractNewResourceCheck {
    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, this::checkStorageAccountDataSource);
        super.initialize(init);
    }

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("azurerm_spring_cloud_app", "azurerm_function_app", "azurerm_function_app_slot", "azurerm_app_service"), (ResourceSymbol resource) -> resource.attribute("https_only").reportIf(ExpressionPredicate.isFalse(), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]).reportIfAbsent("Omitting \"%s\" enables clear-text traffic. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_app_service", (ResourceSymbol resource) -> resource.block("site_config").attribute("ftps_state").reportIf(ExpressionPredicate.equalTo("AllAllowed"), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_cdn_endpoint", (ResourceSymbol resource) -> resource.attribute("is_http_allowed").reportIf(ExpressionPredicate.isTrue(), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]).reportIfAbsent("Omitting \"%s\" enables clear-text traffic. Make sure it is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_redis_enterprise_database", (ResourceSymbol resource) -> resource.attribute("client_protocol").reportIf(ExpressionPredicate.equalTo("PLAINTEXT"), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register(List.of("azurerm_mysql_server", "azurerm_postgresql_server"), (ResourceSymbol resource) -> resource.attribute("ssl_enforcement_enabled").reportIf(ExpressionPredicate.isFalse(), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_storage_account", (ResourceSymbol resource) -> resource.attribute("enable_https_traffic_only").reportIf(ExpressionPredicate.isFalse(), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
        this.register("azurerm_api_management_api", (ResourceSymbol resource) -> resource.list("protocols").reportItemIf(ExpressionPredicate.equalTo("http"), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]));
    }

    private void checkStorageAccountDataSource(CheckContext ctx, BlockTree tree) {
        if ("azurerm_storage_account_blob_container_sas".equals(AzureClearTextProtocolsCheckPart.getDataSourceType(tree))) {
            BlockSymbol.fromPresent(ctx, tree, null).attribute("https_only").reportIf(ExpressionPredicate.isFalse(), "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]);
        }
    }

    @Nullable
    private static String getDataSourceType(BlockTree tree) {
        return "data".equals(tree.key().value()) ? AbstractResourceCheck.getResourceType(tree) : null;
    }
}

