/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.aws;

import java.util.Set;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

public class AwsClearTextProtocolsCheckPart
extends AbstractResourceCheck {
    private static final Set<String> SENSITIVE_LB_DEFAULT_ACTION_TYPES = Set.of("fixed-response", "forward");

    @Override
    protected void registerResourceChecks() {
        this.register(AwsClearTextProtocolsCheckPart::checkMskCluster, "aws_msk_cluster");
        this.register(AwsClearTextProtocolsCheckPart::checkESDomain, "aws_elasticsearch_domain");
        this.register(AwsClearTextProtocolsCheckPart::checkLbListener, "aws_lb_listener");
        this.register(AwsClearTextProtocolsCheckPart::checkESReplicationGroup, "aws_elasticache_replication_group");
        this.register(AwsClearTextProtocolsCheckPart::checkEcsTaskDefinition, "aws_ecs_task_definition");
        this.register(AwsClearTextProtocolsCheckPart::checkKinesisStream, "aws_kinesis_stream");
    }

    private static void checkMskCluster(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "encryption_info", BlockTree.class).flatMap(e -> PropertyUtils.get(e, "encryption_in_transit", BlockTree.class)).ifPresent(e -> {
            AwsClearTextProtocolsCheckPart.checkMskClientBroker(ctx, e);
            AwsClearTextProtocolsCheckPart.reportOnFalseProperty(ctx, e, "in_cluster", "Make sure allowing clear-text traffic is safe here.");
        });
    }

    private static void checkMskClientBroker(CheckContext ctx, BlockTree encryptionBlock) {
        PropertyUtils.get(encryptionBlock, "client_broker", AttributeTree.class).filter(clientBroker -> TextUtils.isValue(clientBroker.value(), "TLS").isFalse()).ifPresent(clientBroker -> ctx.reportIssue((HasTextRange)clientBroker, "Make sure allowing clear-text traffic is safe here."));
    }

    private static void checkESDomain(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "domain_endpoint_options", BlockTree.class).ifPresent(t -> AwsClearTextProtocolsCheckPart.reportOnFalseProperty(ctx, t, "enforce_https", "Make sure allowing clear-text traffic is safe here."));
        PropertyUtils.get(resource, "node_to_node_encryption", BlockTree.class).ifPresentOrElse(encryption -> AwsClearTextProtocolsCheckPart.reportOnFalseProperty(ctx, encryption, "enabled", "Make sure allowing clear-text traffic is safe here."), () -> AwsClearTextProtocolsCheckPart.reportResource(ctx, resource, String.format("Omitting \"%s\" enables clear-text traffic. Make sure it is safe here.", "node_to_node_encryption")));
    }

    private static void reportOnFalseProperty(CheckContext ctx, Tree tree, String propertyName, String message) {
        PropertyUtils.get(tree, propertyName, AttributeTree.class).ifPresent(inCluster -> AwsClearTextProtocolsCheckPart.reportOnFalse(ctx, inCluster, message, new SecondaryLocation[0]));
    }

    private static void checkLbListener(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "protocol", AttributeTree.class).filter(p -> TextUtils.isValue(p.value(), "HTTP").isTrue()).ifPresent(rootProtocol -> AwsClearTextProtocolsCheckPart.checkLbDefaultAction(ctx, resource, rootProtocol));
    }

    private static void checkLbDefaultAction(CheckContext ctx, BlockTree resource, Tree rootProtocol) {
        if (PropertyUtils.getAll(resource, "default_action", BlockTree.class).stream().anyMatch(defaultAction -> AwsClearTextProtocolsCheckPart.isInsecureRedirect(defaultAction) || AwsClearTextProtocolsCheckPart.isSensitiveAction(defaultAction))) {
            ctx.reportIssue(rootProtocol, "Make sure allowing clear-text traffic is safe here.");
        }
    }

    private static boolean isInsecureRedirect(BlockTree defaultAction) {
        return PropertyUtils.get(defaultAction, "redirect", BlockTree.class).flatMap(redirect -> PropertyUtils.value((Tree)redirect, "protocol")).filter(protocol -> TextUtils.isValue(protocol, "HTTP").isTrue()).isPresent();
    }

    private static boolean isSensitiveAction(BlockTree defaultAction) {
        return PropertyUtils.value((Tree)defaultAction, "type").filter(type -> TextUtils.matchesValue(type, SENSITIVE_LB_DEFAULT_ACTION_TYPES::contains).isTrue()).isPresent();
    }

    private static void checkESReplicationGroup(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "transit_encryption_enabled", AttributeTree.class).ifPresentOrElse(encryption -> AwsClearTextProtocolsCheckPart.reportOnFalse(ctx, encryption, "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]), () -> AwsClearTextProtocolsCheckPart.reportResource(ctx, resource, String.format("Omitting \"%s\" enables clear-text traffic. Make sure it is safe here.", "transit_encryption_enabled")));
    }

    private static void checkEcsTaskDefinition(CheckContext ctx, BlockTree resource) {
        PropertyUtils.getAll(resource, "volume", BlockTree.class).forEach(volume -> PropertyUtils.get(volume, "efs_volume_configuration", BlockTree.class).ifPresent(config -> AwsClearTextProtocolsCheckPart.checkEscVolumeConfig(ctx, config)));
    }

    private static void checkEscVolumeConfig(CheckContext ctx, BlockTree config) {
        PropertyUtils.get(config, "transit_encryption", AttributeTree.class).ifPresentOrElse(encryption -> AwsClearTextProtocolsCheckPart.reportSensitiveValue(ctx, encryption, "DISABLED", "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]), () -> ctx.reportIssue(config.key(), String.format("Omitting \"%s\" enables clear-text traffic. Make sure it is safe here.", "transit_encryption")));
    }

    private static void checkKinesisStream(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "encryption_type", AttributeTree.class).ifPresentOrElse(encryption -> AwsClearTextProtocolsCheckPart.reportSensitiveValue(ctx, encryption, "NONE", "Make sure allowing clear-text traffic is safe here.", new SecondaryLocation[0]), () -> AwsClearTextProtocolsCheckPart.reportResource(ctx, resource, String.format("Omitting \"%s\" enables clear-text traffic. Make sure it is safe here.", "encryption_type")));
    }
}

