/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6303")
public class DisabledRDSEncryptionCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted databases is safe here.";
    private static final String OMITTING_MESSAGE = "Omitting \"storage_encrypted\" disables databases encryption. Make sure it is safe here.";
    private static final String SECONDARY_MESSAGE = "Related RDS DBInstance";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_db_instance", (ResourceSymbol resource) -> resource.attribute("storage_encrypted").reportIf(ExpressionPredicate.isFalse(), MESSAGE, resource.toSecondary(SECONDARY_MESSAGE)).reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]));
    }
}

