/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6255")
public class DisabledMfaBucketDeletionCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Make sure allowing object deletion without MFA is safe here.";
    private static final String MESSAGE_SECONDARY = "Related bucket";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_s3_bucket", (ResourceSymbol resource) -> {
            BlockSymbol versioning = resource.block("versioning");
            AttributeSymbol mfaDelete = versioning.attribute("mfa_delete").reportIf(ExpressionPredicate.isFalse(), MESSAGE, resource.toSecondary(MESSAGE_SECONDARY));
            if (mfaDelete.isAbsent()) {
                versioning.report(MESSAGE, resource.toSecondary(MESSAGE_SECONDARY));
            }
        });
    }
}

