/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.common.checks;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PrivilegeEscalationVector {
    CREATE_POLICY_VERSION("iam:CreatePolicyVersion"),
    SET_DEFAULT_POLICY_VERSION("iam:SetDefaultPolicyVersion"),
    CREATE_ACCESS_KEY("iam:CreateAccessKey"),
    CREATE_LOGIN_PROFILE("iam:CreateLoginProfile"),
    UPDATE_LOGIN_PROFILE("iam:UpdateLoginProfile"),
    ATTACH_USER_POLICY("iam:AttachUserPolicy"),
    ATTACH_GROUP_POLICY("iam:AttachGroupPolicy"),
    ATTACH_ROLE_POLICY("iam:AttachRolePolicy", "sts:AssumeRole"),
    PUT_USER_POLICY("iam:PutUserPolicy"),
    PUT_GROUP_POLICY("iam:PutGroupPolicy"),
    PUT_ROLE_POLICY("iam:PutRolePolicy", "sts:AssumeRole"),
    ADD_USER_TO_GROUP("iam:AddUserToGroup"),
    UPDATE_ASSUME_ROLE_POLICY("iam:UpdateAssumeRolePolicy", "sts:AssumeRole"),
    EC2("iam:PassRole", "ec2:RunInstances"),
    LAMBDA_CREATE_AND_INVOKE("iam:PassRole", "lambda:CreateFunction", "lambda:InvokeFunction"),
    LAMBDA_CREATE_AND_ADD_PERMISSION("iam:PassRole", "lambda:CreateFunction", "lambda:AddPermission"),
    LAMBDA_TRIGGERED_WITH_AN_EXTERNAL_EVENT("iam:PassRole", "lambda:CreateFunction", "lambda:CreateEventSourceMapping"),
    CLOUD_FORMATION("iam:PassRole", "cloudformation:CreateStack"),
    DATA_PIPELINE("iam:PassRole", "datapipeline:CreatePipeline", "datapipeline:PutPipelineDefinition"),
    GLUE_DEVELOPMENT_ENDPOINT("iam:PassRole", "glue:CreateDevEndpoint"),
    UPDATE_GLUE_DEV_ENDPOINT("glue:UpdateDevEndpoint"),
    UPDATE_LAMBDA_CODE("lambda:UpdateFunctionCode");

    private final List<Permission.SimplePermission> permissions;

    private PrivilegeEscalationVector(String ... permissions) {
        this.permissions = Stream.of(permissions).map(Permission.SimplePermission::new).collect(Collectors.toList());
    }

    public boolean isSubsetOf(Collection<Permission> actionPermissions) {
        return this.permissions.stream().allMatch(p -> actionPermissions.stream().anyMatch(p::isCoveredBy));
    }

    public static boolean isSupersetOfAnEscalationVector(Stream<String> actionPermissions) {
        Set permissionVector = actionPermissions.map(Permission::of).collect(Collectors.toSet());
        return Stream.of(PrivilegeEscalationVector.values()).anyMatch(vector -> vector.isSubsetOf(permissionVector));
    }

    public static abstract class Permission {
        protected final String permissionName;

        protected Permission(String permissionName) {
            this.permissionName = permissionName;
        }

        public static Permission of(String permissionName) {
            return permissionName.endsWith("*") ? new WildCardPermission(permissionName) : new SimplePermission(permissionName);
        }

        static class WildCardPermission
        extends Permission {
            protected WildCardPermission(String permissionName) {
                super(permissionName);
            }
        }

        static class SimplePermission
        extends Permission {
            protected SimplePermission(String permissionName) {
                super(permissionName);
            }

            public boolean isCoveredBy(Permission other) {
                if (other instanceof WildCardPermission) {
                    return (this.permissionName.substring(0, this.permissionName.indexOf(58) + 1) + "*").equals(other.permissionName);
                }
                return this.permissionName.equals(other.permissionName);
            }
        }
    }
}

