/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.symbols;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.symbols.BlockSymbol;
import org.sonar.iac.terraform.symbols.Symbol;

public class AttributeSymbol
extends Symbol<AttributeTree> {
    protected AttributeSymbol(CheckContext ctx, AttributeTree tree, String name, BlockSymbol parent) {
        super(ctx, tree, name, parent);
    }

    public static AttributeSymbol fromPresent(CheckContext ctx, AttributeTree tree, BlockSymbol parent) {
        return new AttributeSymbol(ctx, tree, tree.key().value(), parent);
    }

    public static AttributeSymbol fromAbsent(CheckContext ctx, String name, BlockSymbol parent) {
        return new AttributeSymbol(ctx, null, name, parent);
    }

    public AttributeSymbol reportIf(Predicate<ExpressionTree> predicate, String message, SecondaryLocation ... secondaries) {
        if (this.tree != null && predicate.test(((AttributeTree)this.tree).value())) {
            return (AttributeSymbol)this.report(message, List.of(secondaries));
        }
        return this;
    }

    public boolean is(Predicate<ExpressionTree> predicate) {
        if (this.tree != null) {
            return predicate.test(((AttributeTree)this.tree).value());
        }
        return predicate.test(null);
    }

    public AttributeSymbol reportIfAbsent(String message, SecondaryLocation ... secondaries) {
        super.reportIfAbsent(message, secondaries);
        return this;
    }

    @Override
    @Nullable
    protected HasTextRange toHighlight() {
        return this.tree;
    }
}

