/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class GcpWeakSSLProtocolCheckPart
extends AbstractNewResourceCheck {
    @Override
    protected void registerResourceConsumer() {
        this.register("google_compute_ssl_policy", (ResourceSymbol resource) -> {
            AttributeSymbol profile;
            AttributeSymbol minTlsVersion = resource.attribute("min_tls_version");
            minTlsVersion.reportIf(ExpressionPredicate.equalTo("TLS_1_0").or(ExpressionPredicate.equalTo("TLS_1_1")), "Change this configuration to use a stronger protocol.", new SecondaryLocation[0]);
            if (minTlsVersion.isAbsent() && ((profile = resource.attribute("profile")).isAbsent() || profile.is(ExpressionPredicate.notEqualTo("RESTRICTED")))) {
                minTlsVersion.reportIfAbsent("Omitting %s disables traffic encryption. Make sure it is safe here.", new SecondaryLocation[0]);
            }
        });
    }
}

