/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.gcp;

import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class GcpClearTextProtocolsCheckPart
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Using HTTP protocol is insecure. Use HTTPS instead.";
    private static final String OMITTING_MESSAGE = "Omitting 'protocol' enables 'HTTP' by default. Use HTTPS instead.";

    @Override
    protected void registerResourceConsumer() {
        this.register("google_compute_region_backend_service", (ResourceSymbol resource) -> resource.attribute("protocol").reportIf(ExpressionPredicate.equalTo("HTTP"), MESSAGE, new SecondaryLocation[0]).reportIfAbsent(OMITTING_MESSAGE, new SecondaryLocation[0]));
    }
}

