/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6330")
public class UnencryptedSqsQueueCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted SQS queues is safe here.";

    @Override
    protected void registerResourceChecks() {
        this.register(UnencryptedSqsQueueCheck::checkQueue, "aws_sqs_queue");
    }

    private static void checkQueue(CheckContext ctx, BlockTree resource) {
        if (PropertyUtils.isMissing(resource, "kms_master_key_id")) {
            UnencryptedSqsQueueCheck.reportResource(ctx, resource, MESSAGE);
        }
    }
}

