/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6388")
public class UnencryptedCloudServicesCheck
extends AbstractNewResourceCheck {
    public static final String UNENCRYPTED_MESSAGE = "Make sure using unencrypted cloud storage is safe here.";
    public static final String FORMAT_OMITTING = "Omitting %s enables clear-text storage. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("azurerm_data_lake_store", (ResourceSymbol resource) -> resource.attribute("encryption_state").reportIf(ExpressionPredicate.equalTo("Disabled"), UNENCRYPTED_MESSAGE, new SecondaryLocation[0]));
        this.register("azurerm_managed_disk", (ResourceSymbol resource) -> resource.attribute("disk_encryption_set_id").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]));
        this.register("azurerm_mysql_server", (ResourceSymbol resource) -> resource.attribute("infrastructure_encryption_enabled").reportIf(ExpressionPredicate.isFalse(), UNENCRYPTED_MESSAGE, new SecondaryLocation[0]).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]));
        this.register("azurerm_windows_virtual_machine_scale_set", (ResourceSymbol resource) -> resource.attribute("encryption_at_host_enabled").reportIf(ExpressionPredicate.isFalse(), UNENCRYPTED_MESSAGE, new SecondaryLocation[0]).reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0]));
        this.register("azurerm_windows_virtual_machine_scale_set", (ResourceSymbol resource) -> List.of("os_disk", "data_disk").forEach(blockName -> resource.block((String)blockName).attribute("disk_encryption_set_id").reportIfAbsent(FORMAT_OMITTING, new SecondaryLocation[0])));
    }
}

