/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.cloudformation.checks;

import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.cloudformation.checks.AbstractResourceCheck;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;

@Rule(key="S6364")
public class ShortBackupRetentionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that defining a short backup retention duration is safe here.";
    private static final int DEFAULT = 7;
    @RuleProperty(key="backup_retention_duration", defaultValue="7")
    int backupRetentionDuration = 7;

    @Override
    protected void checkResource(CheckContext ctx, AbstractResourceCheck.Resource resource) {
        if (resource.isType("AWS::RDS::DBInstance") && PropertyUtils.isMissing(resource.properties(), "SourceDBInstanceIdentifier") || resource.isType("AWS::RDS::DBCluster")) {
            ShortBackupRetentionCheck.checkBackupRetentionPeriod(ctx, resource, this.backupRetentionDuration);
        }
    }

    private static void checkBackupRetentionPeriod(CheckContext ctx, AbstractResourceCheck.Resource resource, int minPeriod) {
        PropertyUtils.value((Tree)resource.properties(), "BackupRetentionPeriod").ifPresentOrElse(period -> TextUtils.getIntValue(period).filter(currentPeriod -> currentPeriod < minPeriod).ifPresent(currentPeriod -> ctx.reportIssue((HasTextRange)period, MESSAGE)), () -> ShortBackupRetentionCheck.reportResource(ctx, resource, MESSAGE));
    }
}

