/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.ResourceVisitor;

@Rule(key="S6388")
public class UnencryptedCloudServicesCheck
extends ResourceVisitor {
    public static final String UNENCRYPTED_MESSAGE = "Make sure using unencrypted cloud storage is safe here.";
    public static final String FORMAT_OMITTING = "Omitting %s enables clear-text storage. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("azurerm_data_lake_store", (ResourceVisitor.Resource resource) -> resource.attribute("encryption_state").reportIfValueMatches("Disabled", UNENCRYPTED_MESSAGE, new SecondaryLocation[0]));
        this.register("azurerm_managed_disk", (ResourceVisitor.Resource resource) -> resource.attribute("disk_encryption_set_id").reportIfAbsence(FORMAT_OMITTING));
        this.register("azurerm_mysql_server", (ResourceVisitor.Resource resource) -> resource.attribute("infrastructure_encryption_enabled").reportIfAbsence(FORMAT_OMITTING).reportIfFalse(UNENCRYPTED_MESSAGE, new SecondaryLocation[0]));
        this.register("azurerm_windows_virtual_machine_scale_set", (ResourceVisitor.Resource resource) -> resource.attribute("encryption_at_host_enabled").reportIfAbsence(FORMAT_OMITTING).reportIfFalse(UNENCRYPTED_MESSAGE, new SecondaryLocation[0]));
        this.register("azurerm_windows_virtual_machine_scale_set", (ResourceVisitor.Resource resource) -> List.of("os_disk", "data_disk").forEach(blockName -> resource.block((String)blockName).ifPresent(block -> block.attribute("disk_encryption_set_id").reportIfAbsence(FORMAT_OMITTING))));
    }
}

