/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6332")
public class DisabledEFSEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted EFS file systems is safe here.";
    private static final String SECONDARY_MESSAGE = "Related file system";

    @Override
    protected void registerResourceChecks() {
        this.register(DisabledEFSEncryptionCheck::checkFileSystem, "aws_efs_file_system");
    }

    private static void checkFileSystem(CheckContext ctx, BlockTree resource) {
        PropertyUtils.get(resource, "encrypted", AttributeTree.class).ifPresentOrElse(encrypted -> DisabledEFSEncryptionCheck.reportOnFalse(ctx, encrypted, MESSAGE, new SecondaryLocation(resource.labels().get(0), SECONDARY_MESSAGE)), () -> DisabledEFSEncryptionCheck.reportResource(ctx, resource, MESSAGE));
    }
}

