/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6330")
public class UnencryptedSqsQueueCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted SQS queues is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        if (UnencryptedSqsQueueCheck.isResource(resource, "aws_sqs_queue") && PropertyUtils.isMissing(resource, "kms_master_key_id")) {
            ctx.reportIssue(resource.labels().get(0), MESSAGE);
        }
    }
}

