/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6319")
public class UnencryptedSageMakerNotebookCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted SageMaker notebook instances is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        if (UnencryptedSageMakerNotebookCheck.isResource(resource, "aws_sagemaker_notebook_instance") && PropertyUtils.isMissing(resource, "kms_key_id")) {
            UnencryptedSageMakerNotebookCheck.reportResource(ctx, resource, MESSAGE);
        }
    }
}

