/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.LabelTree;
import org.sonar.iac.terraform.api.tree.LiteralExprTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6275")
public class UnencryptedEbsVolumeCheck
extends AbstractResourceCheck {
    private static final String[] PROPERTIES = new String[]{"root_block_device", "ebs_block_device"};
    private static final String MESSAGE = "Make sure that using unencrypted volumes is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        String resourceName;
        List<LabelTree> labels = resource.labels();
        if (labels.isEmpty()) {
            return;
        }
        switch (resourceName = labels.get(0).value()) {
            case "aws_ebs_encryption_by_default": {
                UnencryptedEbsVolumeCheck.checkEncrypted(ctx, resource, "enabled", true);
                break;
            }
            case "aws_ebs_volume": {
                UnencryptedEbsVolumeCheck.checkEncrypted(ctx, resource, "encrypted", false);
                break;
            }
            case "aws_launch_configuration": {
                UnencryptedEbsVolumeCheck.checkEncryptionProperties(ctx, resource);
                break;
            }
        }
    }

    private static void checkEncryptionProperties(CheckContext ctx, BlockTree resource) {
        for (String propertyName : PROPERTIES) {
            PropertyUtils.get(resource, propertyName, BlockTree.class).ifPresent(propertyTree -> UnencryptedEbsVolumeCheck.checkEncrypted(ctx, propertyTree, "encrypted", false));
        }
    }

    private static void checkEncrypted(CheckContext ctx, BlockTree tree, String key, boolean secureByDefault) {
        Optional<LiteralExprTree> booleanProperty = PropertyUtils.value(tree, key, TerraformTree.class).filter(x -> x.is(TerraformTree.Kind.BOOLEAN_LITERAL)).map(LiteralExprTree.class::cast);
        if (!booleanProperty.isPresent()) {
            if (secureByDefault) {
                return;
            }
            List<LabelTree> labels = tree.labels();
            ctx.reportIssue(labels.isEmpty() ? tree.key() : (HasTextRange)labels.get(0), MESSAGE);
            return;
        }
        booleanProperty.filter(TextUtils::isValueFalse).ifPresent(value -> ctx.reportIssue((HasTextRange)value, MESSAGE));
    }
}

