/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6333")
public class PublicApiCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure creating a public API is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        if (PublicApiCheck.isResource(resource, "aws_api_gateway_method")) {
            PropertyUtils.value((Tree)resource, "authorization").filter(auth -> TextUtils.isValue(auth, "NONE").isTrue()).ifPresent(auth -> ctx.reportIssue((HasTextRange)auth, MESSAGE, new SecondaryLocation(resource.labels().get(0), "Related method")));
        }
    }
}

