/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6327")
public class DisabledSNSTopicEncryptionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure that using unencrypted SNS topics is safe here.";

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        if (DisabledSNSTopicEncryptionCheck.isResource(resource, "aws_sns_topic") && PropertyUtils.isMissing(resource, "kms_master_key_id")) {
            DisabledSNSTopicEncryptionCheck.reportResource(ctx, resource, MESSAGE);
        }
    }
}

