/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.LabelTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6255")
public class DisabledMfaBucketDeletionCheck
extends AbstractResourceCheck {
    private static final String MESSAGE = "Make sure allowing object deletion of a S3 versioned bucket without MFA is safe here.";
    private static final String MESSAGE_SECONDARY = "Related bucket";

    @Override
    protected void checkResource(CheckContext ctx, BlockTree tree) {
        if (!DisabledMfaBucketDeletionCheck.isS3Bucket(tree)) {
            return;
        }
        LabelTree resourceType = tree.labels().get(0);
        Optional<BlockTree> versioning = PropertyUtils.get(tree, "versioning", BlockTree.class);
        if (versioning.isPresent()) {
            Optional<AttributeTree> mfaDeleteAttribute = PropertyUtils.get(versioning.get(), "mfa_delete", AttributeTree.class);
            if (mfaDeleteAttribute.isPresent()) {
                ExpressionTree value = mfaDeleteAttribute.get().value();
                if (TextUtils.isValueFalse(value)) {
                    ctx.reportIssue((HasTextRange)mfaDeleteAttribute.get(), MESSAGE, new SecondaryLocation(resourceType, MESSAGE_SECONDARY));
                }
                return;
            }
            ctx.reportIssue((HasTextRange)versioning.get().key(), MESSAGE, new SecondaryLocation(resourceType, MESSAGE_SECONDARY));
        }
    }
}

