/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.LiteralExprTree;
import org.sonar.iac.terraform.api.tree.ObjectElementTree;
import org.sonar.iac.terraform.api.tree.ObjectTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

@Rule(key="S6273")
public class AwsTagNameConventionCheck
extends AbstractResourceCheck {
    protected static final String MESSAGE = "Rename tag key \"%s\" to match the regular expression \"%s\".";
    public static final String DEFAULT = "^([A-Z][A-Za-z]*:)*([A-Z][A-Za-z]*)$";
    protected Pattern pattern;
    @RuleProperty(key="format", description="Regular expression used to check the tag keys against.", defaultValue="^([A-Z][A-Za-z]*:)*([A-Z][A-Za-z]*)$")
    public String format = "^([A-Z][A-Za-z]*:)*([A-Z][A-Za-z]*)$";

    @Override
    public void initialize(InitContext init) {
        this.pattern = Pattern.compile(this.format);
        super.initialize(init);
    }

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        AwsTagNameConventionCheck.getTagKeyStream(resource).filter(this::isMismatchingKey).forEach(tagKey -> ctx.reportIssue((HasTextRange)tagKey, String.format(MESSAGE, tagKey.value(), this.format)));
    }

    private static Stream<LiteralExprTree> getTagKeyStream(BlockTree resource) {
        return PropertyUtils.value(resource, "tags", ObjectTree.class).map(o -> o.elements().trees().stream()).orElse(Stream.empty()).map(ObjectElementTree::key).filter(LiteralExprTree.class::isInstance).map(LiteralExprTree.class::cast);
    }

    private boolean isMismatchingKey(LiteralExprTree tagKey) {
        return !this.pattern.matcher(tagKey.value()).matches();
    }
}

