/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import javax.annotation.CheckForNull;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.checks.PropertyUtils;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.api.tree.AttributeTree;
import org.sonar.iac.terraform.api.tree.BlockTree;

public abstract class AbstractResourceCheck
implements IacCheck {
    protected static final String S3_BUCKET = "aws_s3_bucket";

    @Override
    public void initialize(InitContext init) {
        init.register(BlockTree.class, (ctx, tree) -> {
            if (AbstractResourceCheck.isResource(tree)) {
                this.checkResource((CheckContext)ctx, (BlockTree)tree);
            }
        });
    }

    protected abstract void checkResource(CheckContext var1, BlockTree var2);

    public static boolean isResource(BlockTree tree) {
        return TextUtils.isValue(tree.key(), "resource").isTrue();
    }

    public static boolean isResource(BlockTree tree, String type) {
        return AbstractResourceCheck.isResource(tree) && type.equals(AbstractResourceCheck.getResourceType(tree));
    }

    public static boolean isS3Bucket(BlockTree tree) {
        return S3_BUCKET.equals(AbstractResourceCheck.getResourceType(tree));
    }

    public static boolean isS3BucketResource(BlockTree tree) {
        return AbstractResourceCheck.isResource(tree, S3_BUCKET);
    }

    @CheckForNull
    public static String getResourceType(BlockTree tree) {
        return tree.labels().isEmpty() ? null : tree.labels().get(0).value();
    }

    public static void reportOnFalse(CheckContext ctx, AttributeTree attribute, String message) {
        AbstractResourceCheck.reportOnFalse(ctx, attribute.value(), message);
    }

    public static void reportOnFalse(CheckContext ctx, Tree tree, String message) {
        AbstractResourceCheck.reportSensitiveValue(ctx, tree, "false", message);
    }

    public static void reportSensitiveValue(CheckContext ctx, AttributeTree attribute, String sensitiveValue, String message) {
        AbstractResourceCheck.reportSensitiveValue(ctx, attribute.value(), sensitiveValue, message);
    }

    public static void reportSensitiveValue(CheckContext ctx, Tree actualValue, String sensitiveValue, String message) {
        if (TextUtils.isValue(actualValue, sensitiveValue).isTrue()) {
            ctx.reportIssue(actualValue, message);
        }
    }

    public static void reportUnexpectedValue(CheckContext ctx, AttributeTree attribute, String expectedValue, String message) {
        if (TextUtils.isValue(attribute.value(), expectedValue).isFalse()) {
            ctx.reportIssue(attribute.value(), message);
        }
    }

    public static void reportUnexpectedValue(CheckContext ctx, Tree actualValue, String expectedValue, String message) {
        if (TextUtils.isValue(actualValue, expectedValue).isFalse()) {
            ctx.reportIssue(actualValue, message);
        }
    }

    public static void reportResource(CheckContext ctx, BlockTree resource, String message) {
        ctx.reportIssue(resource.labels().get(0), message);
    }

    public static void reportOnDisabled(CheckContext ctx, BlockTree block, boolean enabledByDefault, String message) {
        AbstractResourceCheck.reportOnDisabled(ctx, block, enabledByDefault, message, "enabled");
    }

    public static void reportOnDisabled(CheckContext ctx, BlockTree block, boolean enabledByDefault, String message, String enablingKey) {
        PropertyUtils.value((Tree)block, enablingKey).ifPresentOrElse(enabled -> AbstractResourceCheck.reportOnFalse(ctx, enabled, message), () -> {
            if (!enabledByDefault) {
                ctx.reportIssue(block.key(), message);
            }
        });
    }
}

