/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.checks.AbstractResourceCheck;

public abstract class AbstractMultipleResourcesCheck
extends AbstractResourceCheck {
    private final Map<String, List<BiConsumer<CheckContext, BlockTree>>> resourceChecks = new HashMap<String, List<BiConsumer<CheckContext, BlockTree>>>();

    abstract void registerChecks();

    protected void register(BiConsumer<CheckContext, BlockTree> resourceCheck, String ... resourceNames) {
        Arrays.asList(resourceNames).forEach(resourceName -> this.resourceChecks.computeIfAbsent((String)resourceName, i -> new ArrayList()).add(resourceCheck));
    }

    @Override
    public void initialize(InitContext init) {
        super.initialize(init);
        this.registerChecks();
    }

    @Override
    protected void checkResource(CheckContext ctx, BlockTree resource) {
        String resourceType = AbstractMultipleResourcesCheck.getResourceType(resource);
        if (this.resourceChecks.containsKey(resourceType)) {
            this.resourceChecks.get(resourceType).forEach(consumer -> consumer.accept(ctx, resource));
        }
    }
}

