/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.tree.impl;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.terraform.api.tree.LabelTree;
import org.sonar.iac.terraform.api.tree.SyntaxToken;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.tree.impl.TerraformTreeImpl;

public class LabelTreeImpl
extends TerraformTreeImpl
implements LabelTree {
    private static final Pattern ENCLOSING_QUOTE = Pattern.compile("(^\")|(\"$)");
    private final SyntaxToken token;

    public LabelTreeImpl(SyntaxToken token) {
        this.token = token;
    }

    @Override
    public SyntaxToken token() {
        return this.token;
    }

    @Override
    public String value() {
        return ENCLOSING_QUOTE.matcher(this.token.value()).replaceAll("");
    }

    @Override
    public List<Tree> children() {
        return Collections.singletonList(this.token);
    }

    @Override
    public TerraformTree.Kind getKind() {
        return TerraformTree.Kind.LABEL;
    }
}

