/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.tree.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.terraform.api.tree.BlockTree;
import org.sonar.iac.terraform.api.tree.BodyTree;
import org.sonar.iac.terraform.api.tree.LabelTree;
import org.sonar.iac.terraform.api.tree.StatementTree;
import org.sonar.iac.terraform.api.tree.SyntaxToken;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.tree.impl.TerraformTreeImpl;

public class BlockTreeImpl
extends TerraformTreeImpl
implements BlockTree {
    @Nullable
    private final SyntaxToken dynamicKeyword;
    private final SyntaxToken key;
    private final List<LabelTree> labels;
    private final BodyTree body;
    private final TerraformTree.Kind kind;

    public BlockTreeImpl(@Nullable SyntaxToken dynamic, SyntaxToken key, @Nullable List<LabelTree> labels, BodyTree body, TerraformTree.Kind kind) {
        this.dynamicKeyword = dynamic;
        this.key = key;
        this.labels = Objects.requireNonNullElse(labels, Collections.emptyList());
        this.body = body;
        this.kind = kind;
    }

    @Override
    public List<LabelTree> labels() {
        return this.labels;
    }

    @Override
    public List<StatementTree> properties() {
        return this.body.statements();
    }

    @Override
    public SyntaxToken key() {
        return this.key;
    }

    @Override
    public BodyTree value() {
        return this.body;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamicKeyword != null;
    }

    @Override
    public List<Tree> children() {
        ArrayList<Tree> children = new ArrayList<Tree>();
        children.add(this.key);
        children.addAll(this.labels);
        children.add(this.body);
        return children;
    }

    @Override
    public TerraformTree.Kind getKind() {
        return this.kind;
    }
}

