/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.utils;

import java.util.function.Predicate;
import org.sonar.iac.common.checks.Trilean;
import org.sonar.iac.terraform.api.tree.AttributeAccessTree;
import org.sonar.iac.terraform.api.tree.ExpressionTree;
import org.sonar.iac.terraform.api.tree.TerraformTree;
import org.sonar.iac.terraform.api.tree.VariableExprTree;

public class TerraformUtils {
    private TerraformUtils() {
    }

    public static Trilean attributeAccessMatches(ExpressionTree expression, Predicate<String> predicate) {
        if (expression.is(TerraformTree.Kind.ATTRIBUTE_ACCESS)) {
            return predicate.test(TerraformUtils.attributeAccessToString((AttributeAccessTree)expression)) ? Trilean.TRUE : Trilean.FALSE;
        }
        return Trilean.UNKNOWN;
    }

    public static String attributeAccessToString(AttributeAccessTree attributeAccess) {
        StringBuilder sb = new StringBuilder();
        ExpressionTree object = attributeAccess.object();
        if (object instanceof AttributeAccessTree) {
            AttributeAccessTree attributeAccessTree = (AttributeAccessTree)object;
            sb.append(TerraformUtils.attributeAccessToString(attributeAccessTree));
            sb.append('.');
        } else if (object instanceof VariableExprTree) {
            VariableExprTree variableExprTree = (VariableExprTree)object;
            sb.append(variableExprTree.value());
            sb.append('.');
        }
        sb.append(attributeAccess.attribute().value());
        return sb.toString();
    }
}

