/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks.azure;

import java.util.List;
import java.util.function.Consumer;
import org.sonar.api.utils.Version;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.checks.utils.ExpressionPredicate;
import org.sonar.iac.terraform.plugin.TerraformProviders;
import org.sonar.iac.terraform.symbols.AttributeSymbol;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

public class AzureWeakSSLProtocolCheckPart
extends AbstractNewResourceCheck {
    private static final Version AZURE_VERSION_WITH_SECURE_SETTING_BY_DEFAULT = Version.create(3, 0);

    @Override
    protected void registerResourceConsumer() {
        this.register(List.of("azurerm_postgresql_server", "azurerm_mysql_server"), AzureWeakSSLProtocolCheckPart.checkSSLProtocol("ssl_minimal_tls_version_enforced"));
        this.register("azurerm_storage_account", AzureWeakSSLProtocolCheckPart.checkSSLProtocol("min_tls_version"));
        this.register(List.of("azurerm_mssql_server"), AzureWeakSSLProtocolCheckPart.checkSSLProtocolIgnoreAbsent("minimum_tls_version"));
    }

    private static Consumer<ResourceSymbol> checkSSLProtocol(String protocolAttribute) {
        return resource -> {
            AttributeSymbol protocolAttributeSymbol = resource.attribute(protocolAttribute);
            protocolAttributeSymbol.reportIf(ExpressionPredicate.notEqualTo("TLS1_2"), "Change this code to disable support of older TLS versions.", new SecondaryLocation[0]);
            boolean shouldReportIfAbsent = resource.provider(TerraformProviders.Provider.Identifier.AZURE).hasVersionLowerThan(AZURE_VERSION_WITH_SECURE_SETTING_BY_DEFAULT);
            if (shouldReportIfAbsent) {
                protocolAttributeSymbol.reportIfAbsent("Set \"%s\" to disable support of older TLS versions.", new SecondaryLocation[0]);
            }
        };
    }

    private static Consumer<ResourceSymbol> checkSSLProtocolIgnoreAbsent(String protocolAttribute) {
        return resource -> resource.attribute(protocolAttribute).reportIf(ExpressionPredicate.notEqualTo("1.2"), "Change this code to disable support of older TLS versions.", new SecondaryLocation[0]);
    }
}

