/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.terraform.checks;

import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.checks.TextUtils;
import org.sonar.iac.terraform.checks.AbstractNewResourceCheck;
import org.sonar.iac.terraform.symbols.ResourceSymbol;

@Rule(key="S6330")
public class UnencryptedSqsQueueCheck
extends AbstractNewResourceCheck {
    private static final String MESSAGE = "Setting \"SqsManagedSseEnabled\" to \"false\" disables SQS queues encryption. Make sure it is safe here.";

    @Override
    protected void registerResourceConsumer() {
        this.register("aws_sqs_queue", UnencryptedSqsQueueCheck::checkSqsQueue);
    }

    private static void checkSqsQueue(ResourceSymbol resource) {
        if (resource.attribute("kms_master_key_id").isPresent()) {
            return;
        }
        resource.attribute("sqs_managed_sse_enabled").reportIf(TextUtils::isValueFalse, MESSAGE, new SecondaryLocation[0]);
    }
}

