/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.plugin;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.iac.cloudformation.plugin.CloudformationSensor;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.tree.Tree;
import org.sonar.iac.common.extension.DurationStatistics;
import org.sonar.iac.common.extension.IacSensor;
import org.sonar.iac.common.extension.TreeParser;
import org.sonar.iac.common.extension.visitors.ChecksVisitor;
import org.sonar.iac.common.extension.visitors.InputFileContext;
import org.sonar.iac.common.extension.visitors.TreeVisitor;
import org.sonar.iac.kubernetes.plugin.predicates.KubernetesOrHelmFilePredicate;
import org.sonar.iac.springconfig.checks.SpringConfigCheckList;
import org.sonar.iac.springconfig.parser.SpringConfigParser;
import org.sonar.iac.springconfig.plugin.visitors.SpringConfigHighlightingVisitor;
import org.sonar.iac.springconfig.plugin.visitors.SpringConfigMetricsVisitor;

public class SpringConfigSensor
extends IacSensor {
    private static final Set<String> EXCLUDED_PROFILES = Set.of("dev", "test");
    private final Checks<IacCheck> checks;

    public SpringConfigSensor(SonarRuntime sonarRuntime, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, CheckFactory checkFactory) {
        super(sonarRuntime, fileLinesContextFactory, noSonarFilter, null);
        this.checks = checkFactory.create("java");
        this.checks.addAnnotatedChecks(SpringConfigCheckList.checks());
    }

    @Override
    protected String languageName() {
        return "Java";
    }

    @Override
    protected String repositoryKey() {
        return "java";
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Java Config Sensor").createIssuesForRuleRepositories("java");
    }

    @Override
    protected TreeParser<? extends Tree> treeParser() {
        return new SpringConfigParser();
    }

    @Override
    protected FilePredicate mainFilePredicate(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        Configuration config = sensorContext.config();
        String[] patterns = SpringConfigSensor.getFilePatterns(config);
        return fileSystem.predicates().and(fileSystem.predicates().matchesPathPatterns(patterns), new ProfileNameFilePredicate(), SpringConfigSensor.notMatchedByAnotherYamlSensor(sensorContext));
    }

    @Override
    protected List<TreeVisitor<InputFileContext>> visitors(SensorContext sensorContext, DurationStatistics statistics) {
        return List.of(new ChecksVisitor(this.checks, statistics), new SpringConfigMetricsVisitor(this.fileLinesContextFactory, this.noSonarFilter), new SpringConfigHighlightingVisitor());
    }

    @Override
    protected String getActivationSettingKey() {
        return "sonar.java.springconfig.activate";
    }

    static String[] getFilePatterns(Configuration config) {
        String[] patterns = (String[])Arrays.stream(config.getStringArray("sonar.java.springconfig.file.patterns")).filter(s -> !s.isBlank()).toArray(String[]::new);
        if (patterns.length == 0) {
            patterns = "**/src/main/resources/**/application*.properties,**/src/main/resources/**/application*.yaml,**/src/main/resources/**/application*.yml".split(",");
        }
        return patterns;
    }

    private static FilePredicate notMatchedByAnotherYamlSensor(SensorContext sensorContext) {
        FileSystem fileSystem = sensorContext.fileSystem();
        return fileSystem.predicates().not(fileSystem.predicates().or((FilePredicate)new KubernetesOrHelmFilePredicate(sensorContext), (FilePredicate)new CloudformationSensor.CloudFormationFilePredicate(sensorContext)));
    }

    public static boolean isYamlFile(InputFileContext inputFileContext) {
        return "yaml".equals(inputFileContext.inputFile.language());
    }

    public static boolean isPropertiesFile(InputFileContext inputFileContext) {
        return inputFileContext.inputFile.filename().endsWith(".properties");
    }

    private static class ProfileNameFilePredicate
    implements FilePredicate {
        private static final Pattern SPRING_CONFIG_FILENAME_PATTERN = Pattern.compile("application-(?<name>[^.]++).(properties|yaml|yml)");

        private ProfileNameFilePredicate() {
        }

        @Override
        public boolean apply(InputFile inputFile) {
            Matcher matcher = SPRING_CONFIG_FILENAME_PATTERN.matcher(inputFile.filename());
            if (matcher.matches()) {
                String profileName = matcher.group("name");
                return !EXCLUDED_PROFILES.contains(profileName);
            }
            return true;
        }
    }
}

