/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.parser.yaml;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpringConfigYamlPreprocessor {
    private static final Pattern LINE_SEPARATORS = Pattern.compile("(\r\n|\n|\r|\u2028|\u2029)");
    private static final String DOCUMENT_BREAK = "---";
    private static final int DOCUMENT_BREAK_LENGTH = "---".length();
    private static final Pattern MAVEN_VARIABLE_AT_TOKEN_START = Pattern.compile("([^:]++:\\p{javaWhitespace}*)@(?<name>[^@]++)@(.*+)");
    private static final Predicate<String> containsInlineCommentAfterDocumentBreak = line -> line.startsWith(DOCUMENT_BREAK);
    private static final Predicate<String> containsMavenVariableAtTokenStart = line -> MAVEN_VARIABLE_AT_TOKEN_START.matcher((CharSequence)line).matches();

    public String preprocess(String source) {
        String[] lines = LINE_SEPARATORS.split(source, -1);
        if (Stream.of(lines).noneMatch(containsInlineCommentAfterDocumentBreak.or(containsMavenVariableAtTokenStart))) {
            return source;
        }
        return Stream.of(lines).map(SpringConfigYamlPreprocessor::removeInlineCommentAfterDocumentBreak).map(SpringConfigYamlPreprocessor::transformMavenSubstitutions).collect(Collectors.joining("\n"));
    }

    private static String removeInlineCommentAfterDocumentBreak(String line) {
        String textAfterBreak;
        if (line.startsWith(DOCUMENT_BREAK) && (textAfterBreak = line.substring(DOCUMENT_BREAK_LENGTH).trim()).startsWith("#")) {
            return line.substring(0, line.indexOf(DOCUMENT_BREAK) + DOCUMENT_BREAK_LENGTH);
        }
        return line;
    }

    private static String transformMavenSubstitutions(String line) {
        return MAVEN_VARIABLE_AT_TOKEN_START.matcher(line).replaceAll("$1'${name}$3'");
    }
}

