/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.parser.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.sonar.iac.common.api.tree.Comment;
import org.sonar.iac.common.api.tree.impl.TextRange;
import org.sonar.iac.common.extension.ParseException;
import org.sonar.iac.common.yaml.IacYamlConverter;
import org.sonar.iac.common.yaml.tree.YamlTreeMetadata;
import org.sonar.iac.springconfig.parser.SpringConfigProfileNameUtil;
import org.sonar.iac.springconfig.tree.api.File;
import org.sonar.iac.springconfig.tree.api.Profile;
import org.sonar.iac.springconfig.tree.api.Tuple;
import org.sonar.iac.springconfig.tree.impl.FileImpl;
import org.sonar.iac.springconfig.tree.impl.ProfileImpl;
import org.sonar.iac.springconfig.tree.impl.ScalarImpl;
import org.sonar.iac.springconfig.tree.impl.SyntaxTokenImpl;
import org.sonar.iac.springconfig.tree.impl.TupleImpl;

public class SpringConfigYamlConverter
implements IacYamlConverter<File, Stream<TupleBuilder>> {
    private List<Comment> commentsPerProfile = new ArrayList<Comment>();

    @Override
    public File convertFile(List<Node> nodes) {
        if (nodes.isEmpty()) {
            throw new ParseException("Unexpected empty nodes list while converting file", null, null);
        }
        List<Profile> profiles = nodes.stream().map(this::convertToProfile).toList();
        return new FileImpl(profiles);
    }

    private Profile convertToProfile(Node node) {
        this.commentsPerProfile = new ArrayList<Comment>();
        List<Tuple> tuples = this.convert(node).map(TupleBuilder::build).toList();
        return new ProfileImpl(tuples, this.commentsPerProfile, SpringConfigProfileNameUtil.profileName(tuples), true);
    }

    @Override
    public Stream<TupleBuilder> convert(Node node) {
        this.addComments(node);
        return (Stream)IacYamlConverter.super.convert(node);
    }

    private void addComments(Node node) {
        this.commentsPerProfile.addAll(YamlTreeMetadata.Builder.comments(node));
    }

    @Override
    public Stream<TupleBuilder> convertMapping(MappingNode mappingNode) {
        return mappingNode.getValue().stream().flatMap(nodeTuple -> this.convertTuple((NodeTuple)nodeTuple));
    }

    @Override
    public Stream<TupleBuilder> convertScalar(ScalarNode scalarNode) {
        TextRange range = YamlTreeMetadata.Builder.range(scalarNode);
        TupleBuilder tuple = new TupleBuilder().withValue(scalarNode.getValue()).withValueTextRange(range);
        return Stream.of(tuple);
    }

    @Override
    public Stream<TupleBuilder> convertTuple(NodeTuple tuple) {
        if (!(tuple.getKeyNode() instanceof ScalarNode)) {
            throw new ParseException("Unexpected non-scalar key node in tuple", null, null);
        }
        this.addComments(tuple.getKeyNode());
        String keyPrefix = ((ScalarNode)tuple.getKeyNode()).getValue();
        boolean valueIsScalar = tuple.getValueNode() instanceof ScalarNode;
        return this.convert(tuple.getValueNode()).map(childTuple -> {
            if (valueIsScalar) {
                return childTuple.withKeyTextRange(YamlTreeMetadata.Builder.range(tuple.getKeyNode()));
            }
            return childTuple;
        }).map(childTuple -> childTuple.prefixKeyDelimited(keyPrefix, tuple.getValueNode().getClass()));
    }

    @Override
    public Stream<TupleBuilder> convertSequence(SequenceNode sequenceNode) {
        return IntStream.range(0, sequenceNode.getValue().size()).mapToObj(index -> {
            Node node = sequenceNode.getValue().get(index);
            String keyPrefix = "[" + index + "]";
            return this.convert(node).map(childTuple -> childTuple.prefixKeyDelimited(keyPrefix, node.getClass()));
        }).flatMap(Function.identity());
    }

    public static class TupleBuilder {
        private final List<String> keysReversed = new ArrayList<String>();
        private TextRange keyTextRange;
        private String value;
        private TextRange valueTextRange;

        public TupleBuilder withKeyTextRange(TextRange keyTextRange) {
            this.keyTextRange = keyTextRange;
            return this;
        }

        public TupleBuilder withValue(String value) {
            this.value = value;
            return this;
        }

        public TupleBuilder withValueTextRange(TextRange valueTextRange) {
            this.valueTextRange = valueTextRange;
            return this;
        }

        public Tuple build() {
            if (this.keyTextRange == null) {
                this.keyTextRange = this.valueTextRange;
            }
            SyntaxTokenImpl keyToken = new SyntaxTokenImpl(TupleBuilder.buildKey(this.keysReversed), this.keyTextRange);
            SyntaxTokenImpl valueToken = new SyntaxTokenImpl(this.value, this.valueTextRange);
            return new TupleImpl(new ScalarImpl(keyToken), new ScalarImpl(valueToken));
        }

        private static String buildKey(List<String> keysReversed) {
            StringBuilder sb = new StringBuilder();
            for (int i = keysReversed.size() - 1; i >= 0; --i) {
                sb.append(keysReversed.get(i));
            }
            return sb.toString();
        }

        public TupleBuilder prefixKeyDelimited(String prefix, Class<? extends Node> followingNodeType) {
            if (followingNodeType != ScalarNode.class && followingNodeType != SequenceNode.class) {
                this.keysReversed.add(".");
            }
            this.keysReversed.add(prefix);
            return this;
        }
    }
}

