/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.iac.springconfig.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.iac.common.api.checks.CheckContext;
import org.sonar.iac.common.api.checks.IacCheck;
import org.sonar.iac.common.api.checks.InitContext;
import org.sonar.iac.common.api.checks.SecondaryLocation;
import org.sonar.iac.common.api.tree.HasTextRange;
import org.sonar.iac.springconfig.tree.api.Profile;
import org.sonar.iac.springconfig.tree.api.Scalar;
import org.sonar.iac.springconfig.tree.api.Tuple;

@Rule(key="S4423")
public class WeakSSLProtocolCheck
implements IacCheck {
    private static final String ISSUE_MESSAGE = "Change this code to use a stronger protocol.";
    private static final String SECONDARY_LOCATION_MESSAGE = "Other weak protocol.";
    private static final Set<String> SENSITIVE_KEYS = Set.of("server.ssl.enabled-protocols", "spring.ssl.bundle.jks.server.options.enabled-protocols");
    private static final Set<String> SENSITIVE_VALUES = Set.of("TLSv1.0", "TLSv1.1");
    private static final Pattern SENSITIVE_KEYS_PATTERN = Pattern.compile("(?<key>" + String.join((CharSequence)"|", SENSITIVE_KEYS) + ")\\[\\d+]");

    @Override
    public void initialize(InitContext init) {
        init.register(Profile.class, WeakSSLProtocolCheck::checkProfile);
    }

    private static void checkProfile(CheckContext ctx, Profile profile) {
        HashMap<String, List> sensitiveTuples = new HashMap<String, List>();
        for (Tuple tuple : profile.properties()) {
            Matcher matcher = SENSITIVE_KEYS_PATTERN.matcher(tuple.key().value().value());
            if (!matcher.matches() || !WeakSSLProtocolCheck.hasSensitiveValue(tuple)) continue;
            String key2 = matcher.group("key");
            sensitiveTuples.computeIfAbsent(key2, k -> new ArrayList()).add(tuple);
        }
        sensitiveTuples.forEach((key, value) -> WeakSSLProtocolCheck.reportSensitiveTuples(ctx, value));
    }

    private static boolean hasSensitiveValue(Tuple tuple) {
        Scalar scalarValue = tuple.value();
        return scalarValue != null && SENSITIVE_VALUES.contains(scalarValue.value().value());
    }

    private static void reportSensitiveTuples(CheckContext ctx, List<Tuple> sensitiveTuples) {
        if (sensitiveTuples.isEmpty()) {
            return;
        }
        List<SecondaryLocation> secondaryLocations = sensitiveTuples.stream().skip(1L).map(tuple -> new SecondaryLocation((HasTextRange)tuple, SECONDARY_LOCATION_MESSAGE)).toList();
        ctx.reportIssue((HasTextRange)sensitiveTuples.get(0), ISSUE_MESSAGE, secondaryLocations);
    }
}

